% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_update_knowledge_base}
\alias{bedrockagent_update_knowledge_base}
\title{Updates the configuration of a knowledge base with the fields that you
specify}
\usage{
bedrockagent_update_knowledge_base(
  description = NULL,
  knowledgeBaseConfiguration,
  knowledgeBaseId,
  name,
  roleArn,
  storageConfiguration = NULL
)
}
\arguments{
\item{description}{Specifies a new description for the knowledge base.}

\item{knowledgeBaseConfiguration}{[required] Specifies the configuration for the embeddings model used for the
knowledge base. You must use the same configuration as when the
knowledge base was created.}

\item{knowledgeBaseId}{[required] The unique identifier of the knowledge base to update.}

\item{name}{[required] Specifies a new name for the knowledge base.}

\item{roleArn}{[required] Specifies a different Amazon Resource Name (ARN) of the IAM role with
permissions to invoke API operations on the knowledge base.}

\item{storageConfiguration}{Specifies the configuration for the vector store used for the knowledge
base. You must use the same configuration as when the knowledge base was
created.}
}
\description{
Updates the configuration of a knowledge base with the fields that you specify. Because all fields will be overwritten, you must include the same values for fields that you want to keep the same.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_update_knowledge_base/} for full documentation.
}
\keyword{internal}
