% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutequipment_operations.R
\name{lookoutequipment_create_inference_scheduler}
\alias{lookoutequipment_create_inference_scheduler}
\title{Creates a scheduled inference}
\usage{
lookoutequipment_create_inference_scheduler(
  ModelName,
  InferenceSchedulerName,
  DataDelayOffsetInMinutes = NULL,
  DataUploadFrequency,
  DataInputConfiguration,
  DataOutputConfiguration,
  RoleArn,
  ServerSideKmsKeyId = NULL,
  ClientToken,
  Tags = NULL
)
}
\arguments{
\item{ModelName}{[required] The name of the previously trained machine learning model being used to
create the inference scheduler.}

\item{InferenceSchedulerName}{[required] The name of the inference scheduler being created.}

\item{DataDelayOffsetInMinutes}{The interval (in minutes) of planned delay at the start of each
inference segment. For example, if inference is set to run every ten
minutes, the delay is set to five minutes and the time is 09:08. The
inference scheduler will wake up at the configured interval (which,
without a delay configured, would be 09:10) plus the additional five
minute delay time (so 09:15) to check your Amazon S3 bucket. The delay
provides a buffer for you to upload data at the same frequency, so that
you don't have to stop and restart the scheduler when uploading new
data.

For more information, see \href{https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-inference-process.html}{Understanding the inference process}.}

\item{DataUploadFrequency}{[required] How often data is uploaded to the source Amazon S3 bucket for the input
data. The value chosen is the length of time between data uploads. For
instance, if you select 5 minutes, Amazon Lookout for Equipment will
upload the real-time data to the source bucket once every 5 minutes.
This frequency also determines how often Amazon Lookout for Equipment
runs inference on your data.

For more information, see \href{https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-inference-process.html}{Understanding the inference process}.}

\item{DataInputConfiguration}{[required] Specifies configuration information for the input data for the inference
scheduler, including delimiter, format, and dataset location.}

\item{DataOutputConfiguration}{[required] Specifies configuration information for the output results for the
inference scheduler, including the S3 location for the output.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of a role with permission to access the
data source being used for the inference.}

\item{ServerSideKmsKeyId}{Provides the identifier of the KMS key used to encrypt inference
scheduler data by Amazon Lookout for Equipment.}

\item{ClientToken}{[required] A unique identifier for the request. If you do not set the client
request token, Amazon Lookout for Equipment generates one.}

\item{Tags}{Any tags associated with the inference scheduler.}
}
\description{
Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to analyze new measurement data. When setting up the schedule, you provide an S3 bucket location for the input data, assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency of inferencing. You must also provide an S3 bucket location for the output data.

See \url{https://www.paws-r-sdk.com/docs/lookoutequipment_create_inference_scheduler/} for full documentation.
}
\keyword{internal}
