% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_disable_metrics_collection}
\alias{autoscaling_disable_metrics_collection}
\title{Disables group metrics collection for the specified Auto Scaling group}
\usage{
autoscaling_disable_metrics_collection(AutoScalingGroupName, Metrics = NULL)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{Metrics}{Identifies the metrics to disable.

You can specify one or more of the following metrics:
\itemize{
\item \code{GroupMinSize}
\item \code{GroupMaxSize}
\item \code{GroupDesiredCapacity}
\item \code{GroupInServiceInstances}
\item \code{GroupPendingInstances}
\item \code{GroupStandbyInstances}
\item \code{GroupTerminatingInstances}
\item \code{GroupTotalInstances}
\item \code{GroupInServiceCapacity}
\item \code{GroupPendingCapacity}
\item \code{GroupStandbyCapacity}
\item \code{GroupTerminatingCapacity}
\item \code{GroupTotalCapacity}
\item \code{WarmPoolDesiredCapacity}
\item \code{WarmPoolWarmedCapacity}
\item \code{WarmPoolPendingCapacity}
\item \code{WarmPoolTerminatingCapacity}
\item \code{WarmPoolTotalCapacity}
\item \code{GroupAndWarmPoolDesiredCapacity}
\item \code{GroupAndWarmPoolTotalCapacity}
}

If you omit this property, all metrics are disabled.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html}{Amazon CloudWatch metrics for Amazon EC2 Auto Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}
}
\description{
Disables group metrics collection for the specified Auto Scaling group.

See \url{https://www.paws-r-sdk.com/docs/autoscaling_disable_metrics_collection/} for full documentation.
}
\keyword{internal}
