% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_subscription_filter}
\alias{cloudwatchlogs_put_subscription_filter}
\title{Creates or updates a subscription filter and associates it with the
specified log group}
\usage{
cloudwatchlogs_put_subscription_filter(
  logGroupName,
  filterName,
  filterPattern,
  destinationArn,
  roleArn = NULL,
  distribution = NULL,
  applyOnTransformedLogs = NULL
)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{filterName}{[required] A name for the subscription filter. If you are updating an existing
filter, you must specify the correct name in \code{filterName}. To find the
name of the filter currently associated with a log group, use
\code{\link[=cloudwatchlogs_describe_subscription_filters]{describe_subscription_filters}}.}

\item{filterPattern}{[required] A filter pattern for subscribing to a filtered stream of log events.}

\item{destinationArn}{[required] The ARN of the destination to deliver matching log events to. Currently,
the supported destinations are:
\itemize{
\item An Amazon Kinesis stream belonging to the same account as the
subscription filter, for same-account delivery.
\item A logical destination (specified using an ARN) belonging to a
different account, for cross-account delivery.

If you're setting up a cross-account subscription, the destination
must have an IAM policy associated with it. The IAM policy must
allow the sender to send logs to the destination. For more
information, see
\code{\link[=cloudwatchlogs_put_destination_policy]{put_destination_policy}}.
\item A Kinesis Data Firehose delivery stream belonging to the same
account as the subscription filter, for same-account delivery.
\item A Lambda function belonging to the same account as the subscription
filter, for same-account delivery.
}}

\item{roleArn}{The ARN of an IAM role that grants CloudWatch Logs permissions to
deliver ingested log events to the destination stream. You don't need to
provide the ARN when you are working with a logical destination for
cross-account delivery.}

\item{distribution}{The method used to distribute log data to the destination. By default,
log data is grouped by log stream, but the grouping can be set to random
for a more even distribution. This property is only applicable when the
destination is an Amazon Kinesis data stream.}

\item{applyOnTransformedLogs}{This parameter is valid only for log groups that have an active log
transformer. For more information about log transformers, see
\code{\link[=cloudwatchlogs_put_transformer]{put_transformer}}.

If the log group uses either a log-group level or account-level
transformer, and you specify \code{true}, the subscription filter will be
applied on the transformed version of the log events instead of the
original ingested log events.}
}
\description{
Creates or updates a subscription filter and associates it with the specified log group. With subscription filters, you can subscribe to a real-time stream of log events ingested through \code{\link[=cloudwatchlogs_put_log_events]{put_log_events}} and have them delivered to a specific destination. When log events are sent to the receiving service, they are Base64 encoded and compressed with the GZIP format.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_subscription_filter/} for full documentation.
}
\keyword{internal}
