% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_get_analysis_report_results}
\alias{networkfirewall_get_analysis_report_results}
\title{The results of a COMPLETED analysis report generated with
StartAnalysisReport}
\usage{
networkfirewall_get_analysis_report_results(
  FirewallName = NULL,
  AnalysisReportId,
  FirewallArn = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{FirewallName}{The descriptive name of the firewall. You can't change the name of a
firewall after you create it.

You must specify the ARN or the name, and you can specify both.}

\item{AnalysisReportId}{[required] The unique ID of the query that ran when you requested an analysis
report.}

\item{FirewallArn}{The Amazon Resource Name (ARN) of the firewall.

You must specify the ARN or the name, and you can specify both.}

\item{NextToken}{When you request a list of objects with a \code{MaxResults} setting, if the
number of objects that are still available for retrieval exceeds the
maximum you requested, Network Firewall returns a \code{NextToken} value in
the response. To retrieve the next batch of objects, use the token
returned from the prior request in your next request.}

\item{MaxResults}{The maximum number of objects that you want Network Firewall to return
for this request. If more objects are available, in the response,
Network Firewall provides a \code{NextToken} value that you can use in a
subsequent call to get the next batch of objects.}
}
\description{
The results of a \code{COMPLETED} analysis report generated with \code{\link[=networkfirewall_start_analysis_report]{start_analysis_report}}.

See \url{https://www.paws-r-sdk.com/docs/networkfirewall_get_analysis_report_results/} for full documentation.
}
\keyword{internal}
