% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfrontkeyvaluestore_service.R
\name{cloudfrontkeyvaluestore}
\alias{cloudfrontkeyvaluestore}
\title{Amazon CloudFront KeyValueStore}
\usage{
cloudfrontkeyvaluestore(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon CloudFront KeyValueStore Service to View and Update Data in a KVS
Resource
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- cloudfrontkeyvaluestore(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=cloudfrontkeyvaluestore_delete_key]{delete_key} \tab Deletes the key value pair specified by the key\cr
\link[=cloudfrontkeyvaluestore_describe_key_value_store]{describe_key_value_store} \tab Returns metadata information about Key Value Store\cr
\link[=cloudfrontkeyvaluestore_get_key]{get_key} \tab Returns a key value pair\cr
\link[=cloudfrontkeyvaluestore_list_keys]{list_keys} \tab Returns a list of key value pairs\cr
\link[=cloudfrontkeyvaluestore_put_key]{put_key} \tab Creates a new key value pair or replaces the value of an existing key\cr
\link[=cloudfrontkeyvaluestore_update_keys]{update_keys} \tab Puts or Deletes multiple key value pairs in a single, all-or-nothing operation
}
}

\examples{
\dontrun{
svc <- cloudfrontkeyvaluestore()
svc$delete_key(
  Foo = 123
)
}

}
