% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_set_ip_address_type}
\alias{elbv2_set_ip_address_type}
\title{Sets the type of IP addresses used by the subnets of the specified load
balancer}
\usage{
elbv2_set_ip_address_type(LoadBalancerArn, IpAddressType)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}

\item{IpAddressType}{[required] The IP address type. Internal load balancers must use \code{ipv4}.

[Application Load Balancers] The possible values are \code{ipv4} (IPv4
addresses), \code{dualstack} (IPv4 and IPv6 addresses), and
\code{dualstack-without-public-ipv4} (public IPv6 addresses and private IPv4
and IPv6 addresses).

Application Load Balancer authentication supports IPv4 addresses only
when connecting to an Identity Provider (IdP) or Amazon Cognito
endpoint. Without a public IPv4 address the load balancer can't complete
the authentication process, resulting in HTTP 500 errors.

[Network Load Balancers and Gateway Load Balancers] The possible
values are \code{ipv4} (IPv4 addresses) and \code{dualstack} (IPv4 and IPv6
addresses).}
}
\description{
Sets the type of IP addresses used by the subnets of the specified load balancer.

See \url{https://www.paws-r-sdk.com/docs/elbv2_set_ip_address_type/} for full documentation.
}
\keyword{internal}
