% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_permissions}
\alias{ram_list_permissions}
\title{Retrieves a list of available RAM permissions that you can use for the
supported resource types}
\usage{
ram_list_permissions(
  resourceType = NULL,
  nextToken = NULL,
  maxResults = NULL,
  permissionType = NULL
)
}
\arguments{
\item{resourceType}{Specifies that you want to list only those permissions that apply to the
specified resource type. This parameter is not case sensitive.

For example, to list only permissions that apply to Amazon EC2 subnets,
specify \code{ec2:subnet}. You can use the
\code{\link[=ram_list_resource_types]{list_resource_types}} operation to get the
specific string required.}

\item{nextToken}{Specifies that you want to receive the next page of results. Valid only
if you received a \code{NextToken} response in the previous request. If you
did, it indicates that more output is available. Set this parameter to
the value provided by the previous call's \code{NextToken} response to
request the next page of results.}

\item{maxResults}{Specifies the total number of results that you want included on each
page of the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the number you specify, the \code{NextToken} response element is
returned with a value (not null). Include the specified value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that the service might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}

\item{permissionType}{Specifies that you want to list only permissions of this type:
\itemize{
\item \code{AWS} – returns only Amazon Web Services managed permissions.
\item \code{LOCAL} – returns only customer managed permissions
\item \code{ALL} – returns both Amazon Web Services managed permissions and
customer managed permissions.
}

If you don't specify this parameter, the default is \code{All}.}
}
\description{
Retrieves a list of available RAM permissions that you can use for the supported resource types.

See \url{https://www.paws-r-sdk.com/docs/ram_list_permissions/} for full documentation.
}
\keyword{internal}
