% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssooidc_operations.R
\name{ssooidc_create_token}
\alias{ssooidc_create_token}
\title{Creates and returns access and refresh tokens for clients that are
authenticated using client secrets}
\usage{
ssooidc_create_token(
  clientId,
  clientSecret,
  grantType,
  deviceCode = NULL,
  code = NULL,
  refreshToken = NULL,
  scope = NULL,
  redirectUri = NULL,
  codeVerifier = NULL
)
}
\arguments{
\item{clientId}{[required] The unique identifier string for the client or application. This value
comes from the result of the
\code{\link[=ssooidc_register_client]{register_client}} API.}

\item{clientSecret}{[required] A secret string generated for the client. This value should come from
the persisted result of the \code{\link[=ssooidc_register_client]{register_client}}
API.}

\item{grantType}{[required] Supports the following OAuth grant types: Authorization Code, Device
Code, and Refresh Token. Specify one of the following values, depending
on the grant type that you want:
\itemize{
\item Authorization Code - \code{authorization_code}
\item Device Code - \code{urn:ietf:params:oauth:grant-type:device_code}
\item Refresh Token - \code{refresh_token}
}}

\item{deviceCode}{Used only when calling this API for the Device Code grant type. This
short-lived code is used to identify this authorization request. This
comes from the result of the
\code{\link[=ssooidc_start_device_authorization]{start_device_authorization}} API.}

\item{code}{Used only when calling this API for the Authorization Code grant type.
The short-lived code is used to identify this authorization request.}

\item{refreshToken}{Used only when calling this API for the Refresh Token grant type. This
token is used to refresh short-lived tokens, such as the access token,
that might expire.

For more information about the features and limitations of the current
IAM Identity Center OIDC implementation, see \emph{Considerations for Using
this Guide} in the \href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html}{IAM Identity Center OIDC API Reference}.}

\item{scope}{The list of scopes for which authorization is requested. The access
token that is issued is limited to the scopes that are granted. If this
value is not specified, IAM Identity Center authorizes all scopes that
are configured for the client during the call to
\code{\link[=ssooidc_register_client]{register_client}}.}

\item{redirectUri}{Used only when calling this API for the Authorization Code grant type.
This value specifies the location of the client or application that has
registered to receive the authorization code.}

\item{codeVerifier}{Used only when calling this API for the Authorization Code grant type.
This value is generated by the client and presented to validate the
original code challenge value the client passed at authorization time.}
}
\description{
Creates and returns access and refresh tokens for clients that are authenticated using client secrets. The access token can be used to fetch short-lived credentials for the assigned AWS accounts or to access application APIs using \code{bearer} authentication.

See \url{https://www.paws-r-sdk.com/docs/ssooidc_create_token/} for full documentation.
}
\keyword{internal}
