# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include s3tables_service.R
NULL

#' Creates a namespace
#'
#' @description
#' Creates a namespace. A namespace is a logical grouping of tables within your table bucket, which you can use to organize tables. For more information, see [Create a namespace](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace-create.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_create_namespace/](https://www.paws-r-sdk.com/docs/s3tables_create_namespace/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket to create the
#' namespace in.
#' @param namespace &#91;required&#93; A name for the namespace.
#'
#' @keywords internal
#'
#' @rdname s3tables_create_namespace
s3tables_create_namespace <- function(tableBucketARN, namespace) {
  op <- new_operation(
    name = "CreateNamespace",
    http_method = "PUT",
    http_path = "/namespaces/{tableBucketARN}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$create_namespace_input(tableBucketARN = tableBucketARN, namespace = namespace)
  output <- .s3tables$create_namespace_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$create_namespace <- s3tables_create_namespace

#' Creates a new table associated with the given namespace in a table
#' bucket
#'
#' @description
#' Creates a new table associated with the given namespace in a table bucket. For more information, see [Creating an Amazon S3 table](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-create.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_create_table/](https://www.paws-r-sdk.com/docs/s3tables_create_table/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket to create the table
#' in.
#' @param namespace &#91;required&#93; The namespace to associated with the table.
#' @param name &#91;required&#93; The name for the table.
#' @param format &#91;required&#93; The format for the table.
#' @param metadata The metadata for the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_create_table
s3tables_create_table <- function(tableBucketARN, namespace, name, format, metadata = NULL) {
  op <- new_operation(
    name = "CreateTable",
    http_method = "PUT",
    http_path = "/tables/{tableBucketARN}/{namespace}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$create_table_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name, format = format, metadata = metadata)
  output <- .s3tables$create_table_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$create_table <- s3tables_create_table

#' Creates a table bucket
#'
#' @description
#' Creates a table bucket. For more information, see [Creating a table bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-create.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_create_table_bucket/](https://www.paws-r-sdk.com/docs/s3tables_create_table_bucket/) for full documentation.
#'
#' @param name &#91;required&#93; The name for the table bucket.
#'
#' @keywords internal
#'
#' @rdname s3tables_create_table_bucket
s3tables_create_table_bucket <- function(name) {
  op <- new_operation(
    name = "CreateTableBucket",
    http_method = "PUT",
    http_path = "/buckets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$create_table_bucket_input(name = name)
  output <- .s3tables$create_table_bucket_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$create_table_bucket <- s3tables_create_table_bucket

#' Deletes a namespace
#'
#' @description
#' Deletes a namespace. For more information, see [Delete a namespace](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace-delete.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_delete_namespace/](https://www.paws-r-sdk.com/docs/s3tables_delete_namespace/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket associated with the
#' namespace.
#' @param namespace &#91;required&#93; The name of the namespace.
#'
#' @keywords internal
#'
#' @rdname s3tables_delete_namespace
s3tables_delete_namespace <- function(tableBucketARN, namespace) {
  op <- new_operation(
    name = "DeleteNamespace",
    http_method = "DELETE",
    http_path = "/namespaces/{tableBucketARN}/{namespace}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$delete_namespace_input(tableBucketARN = tableBucketARN, namespace = namespace)
  output <- .s3tables$delete_namespace_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$delete_namespace <- s3tables_delete_namespace

#' Deletes a table
#'
#' @description
#' Deletes a table. For more information, see [Deleting an Amazon S3 table](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-delete.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_delete_table/](https://www.paws-r-sdk.com/docs/s3tables_delete_table/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket that contains the
#' table.
#' @param namespace &#91;required&#93; The namespace associated with the table.
#' @param name &#91;required&#93; The name of the table.
#' @param versionToken The version token of the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_delete_table
s3tables_delete_table <- function(tableBucketARN, namespace, name, versionToken = NULL) {
  op <- new_operation(
    name = "DeleteTable",
    http_method = "DELETE",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$delete_table_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name, versionToken = versionToken)
  output <- .s3tables$delete_table_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$delete_table <- s3tables_delete_table

#' Deletes a table bucket
#'
#' @description
#' Deletes a table bucket. For more information, see [Deleting a table bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-delete.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_delete_table_bucket/](https://www.paws-r-sdk.com/docs/s3tables_delete_table_bucket/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#'
#' @keywords internal
#'
#' @rdname s3tables_delete_table_bucket
s3tables_delete_table_bucket <- function(tableBucketARN) {
  op <- new_operation(
    name = "DeleteTableBucket",
    http_method = "DELETE",
    http_path = "/buckets/{tableBucketARN}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$delete_table_bucket_input(tableBucketARN = tableBucketARN)
  output <- .s3tables$delete_table_bucket_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$delete_table_bucket <- s3tables_delete_table_bucket

#' Deletes a table bucket policy
#'
#' @description
#' Deletes a table bucket policy. For more information, see [Deleting a table bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-delete) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_delete_table_bucket_policy/](https://www.paws-r-sdk.com/docs/s3tables_delete_table_bucket_policy/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#'
#' @keywords internal
#'
#' @rdname s3tables_delete_table_bucket_policy
s3tables_delete_table_bucket_policy <- function(tableBucketARN) {
  op <- new_operation(
    name = "DeleteTableBucketPolicy",
    http_method = "DELETE",
    http_path = "/buckets/{tableBucketARN}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$delete_table_bucket_policy_input(tableBucketARN = tableBucketARN)
  output <- .s3tables$delete_table_bucket_policy_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$delete_table_bucket_policy <- s3tables_delete_table_bucket_policy

#' Deletes a table policy
#'
#' @description
#' Deletes a table policy. For more information, see [Deleting a table policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-delete) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_delete_table_policy/](https://www.paws-r-sdk.com/docs/s3tables_delete_table_policy/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket that contains the
#' table.
#' @param namespace &#91;required&#93; The namespace associated with the table.
#' @param name &#91;required&#93; The table name.
#'
#' @keywords internal
#'
#' @rdname s3tables_delete_table_policy
s3tables_delete_table_policy <- function(tableBucketARN, namespace, name) {
  op <- new_operation(
    name = "DeleteTablePolicy",
    http_method = "DELETE",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$delete_table_policy_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name)
  output <- .s3tables$delete_table_policy_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$delete_table_policy <- s3tables_delete_table_policy

#' Gets details about a namespace
#'
#' @description
#' Gets details about a namespace. For more information, see [Table namespaces](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_namespace/](https://www.paws-r-sdk.com/docs/s3tables_get_namespace/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#' @param namespace &#91;required&#93; The name of the namespace.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_namespace
s3tables_get_namespace <- function(tableBucketARN, namespace) {
  op <- new_operation(
    name = "GetNamespace",
    http_method = "GET",
    http_path = "/namespaces/{tableBucketARN}/{namespace}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_namespace_input(tableBucketARN = tableBucketARN, namespace = namespace)
  output <- .s3tables$get_namespace_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_namespace <- s3tables_get_namespace

#' Gets details about a table
#'
#' @description
#' Gets details about a table. For more information, see [S3 Tables](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_table/](https://www.paws-r-sdk.com/docs/s3tables_get_table/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket associated with the
#' table.
#' @param namespace &#91;required&#93; The name of the namespace the table is associated with.
#' @param name &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_table
s3tables_get_table <- function(tableBucketARN, namespace, name) {
  op <- new_operation(
    name = "GetTable",
    http_method = "GET",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_table_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name)
  output <- .s3tables$get_table_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_table <- s3tables_get_table

#' Gets details on a table bucket
#'
#' @description
#' Gets details on a table bucket. For more information, see [Viewing details about an Amazon S3 table bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-details.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_table_bucket/](https://www.paws-r-sdk.com/docs/s3tables_get_table_bucket/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_table_bucket
s3tables_get_table_bucket <- function(tableBucketARN) {
  op <- new_operation(
    name = "GetTableBucket",
    http_method = "GET",
    http_path = "/buckets/{tableBucketARN}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_table_bucket_input(tableBucketARN = tableBucketARN)
  output <- .s3tables$get_table_bucket_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_table_bucket <- s3tables_get_table_bucket

#' Gets details about a maintenance configuration for a given table bucket
#'
#' @description
#' Gets details about a maintenance configuration for a given table bucket. For more information, see [Amazon S3 table bucket maintenance](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_table_bucket_maintenance_configuration/](https://www.paws-r-sdk.com/docs/s3tables_get_table_bucket_maintenance_configuration/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket associated with the
#' maintenance configuration.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_table_bucket_maintenance_configuration
s3tables_get_table_bucket_maintenance_configuration <- function(tableBucketARN) {
  op <- new_operation(
    name = "GetTableBucketMaintenanceConfiguration",
    http_method = "GET",
    http_path = "/buckets/{tableBucketARN}/maintenance",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_table_bucket_maintenance_configuration_input(tableBucketARN = tableBucketARN)
  output <- .s3tables$get_table_bucket_maintenance_configuration_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_table_bucket_maintenance_configuration <- s3tables_get_table_bucket_maintenance_configuration

#' Gets details about a table bucket policy
#'
#' @description
#' Gets details about a table bucket policy. For more information, see [Viewing a table bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-get) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_table_bucket_policy/](https://www.paws-r-sdk.com/docs/s3tables_get_table_bucket_policy/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_table_bucket_policy
s3tables_get_table_bucket_policy <- function(tableBucketARN) {
  op <- new_operation(
    name = "GetTableBucketPolicy",
    http_method = "GET",
    http_path = "/buckets/{tableBucketARN}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_table_bucket_policy_input(tableBucketARN = tableBucketARN)
  output <- .s3tables$get_table_bucket_policy_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_table_bucket_policy <- s3tables_get_table_bucket_policy

#' Gets details about the maintenance configuration of a table
#'
#' @description
#' Gets details about the maintenance configuration of a table. For more information, see [S3 Tables maintenance](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_table_maintenance_configuration/](https://www.paws-r-sdk.com/docs/s3tables_get_table_maintenance_configuration/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#' @param namespace &#91;required&#93; The namespace associated with the table.
#' @param name &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_table_maintenance_configuration
s3tables_get_table_maintenance_configuration <- function(tableBucketARN, namespace, name) {
  op <- new_operation(
    name = "GetTableMaintenanceConfiguration",
    http_method = "GET",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/maintenance",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_table_maintenance_configuration_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name)
  output <- .s3tables$get_table_maintenance_configuration_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_table_maintenance_configuration <- s3tables_get_table_maintenance_configuration

#' Gets the status of a maintenance job for a table
#'
#' @description
#' Gets the status of a maintenance job for a table. For more information, see [S3 Tables maintenance](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_table_maintenance_job_status/](https://www.paws-r-sdk.com/docs/s3tables_get_table_maintenance_job_status/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#' @param namespace &#91;required&#93; The name of the namespace the table is associated with.
#' 
#'     </p> 
#' @param name &#91;required&#93; The name of the maintenance job.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_table_maintenance_job_status
s3tables_get_table_maintenance_job_status <- function(tableBucketARN, namespace, name) {
  op <- new_operation(
    name = "GetTableMaintenanceJobStatus",
    http_method = "GET",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/maintenance-job-status",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_table_maintenance_job_status_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name)
  output <- .s3tables$get_table_maintenance_job_status_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_table_maintenance_job_status <- s3tables_get_table_maintenance_job_status

#' Gets the location of the table metadata
#'
#' @description
#' Gets the location of the table metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_table_metadata_location/](https://www.paws-r-sdk.com/docs/s3tables_get_table_metadata_location/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#' @param namespace &#91;required&#93; The namespace of the table.
#' @param name &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_table_metadata_location
s3tables_get_table_metadata_location <- function(tableBucketARN, namespace, name) {
  op <- new_operation(
    name = "GetTableMetadataLocation",
    http_method = "GET",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/metadata-location",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_table_metadata_location_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name)
  output <- .s3tables$get_table_metadata_location_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_table_metadata_location <- s3tables_get_table_metadata_location

#' Gets details about a table policy
#'
#' @description
#' Gets details about a table policy. For more information, see [Viewing a table policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-get) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_get_table_policy/](https://www.paws-r-sdk.com/docs/s3tables_get_table_policy/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket that contains the
#' table.
#' @param namespace &#91;required&#93; The namespace associated with the table.
#' @param name &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_get_table_policy
s3tables_get_table_policy <- function(tableBucketARN, namespace, name) {
  op <- new_operation(
    name = "GetTablePolicy",
    http_method = "GET",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$get_table_policy_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name)
  output <- .s3tables$get_table_policy_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$get_table_policy <- s3tables_get_table_policy

#' Lists the namespaces within a table bucket
#'
#' @description
#' Lists the namespaces within a table bucket. For more information, see [Table namespaces](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_list_namespaces/](https://www.paws-r-sdk.com/docs/s3tables_list_namespaces/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#' @param prefix The prefix of the namespaces.
#' @param continuationToken `ContinuationToken` indicates to Amazon S3 that the list is being
#' continued on this bucket with a token. `ContinuationToken` is obfuscated
#' and is not a real key. You can use this `ContinuationToken` for
#' pagination of the list results.
#' @param maxNamespaces The maximum number of namespaces to return in the list.
#'
#' @keywords internal
#'
#' @rdname s3tables_list_namespaces
s3tables_list_namespaces <- function(tableBucketARN, prefix = NULL, continuationToken = NULL, maxNamespaces = NULL) {
  op <- new_operation(
    name = "ListNamespaces",
    http_method = "GET",
    http_path = "/namespaces/{tableBucketARN}",
    host_prefix = "",
    paginator = list(input_token = "continuationToken", output_token = "continuationToken", limit_key = "maxNamespaces", result_key = "namespaces"),
    stream_api = FALSE
  )
  input <- .s3tables$list_namespaces_input(tableBucketARN = tableBucketARN, prefix = prefix, continuationToken = continuationToken, maxNamespaces = maxNamespaces)
  output <- .s3tables$list_namespaces_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$list_namespaces <- s3tables_list_namespaces

#' Lists table buckets for your account
#'
#' @description
#' Lists table buckets for your account. For more information, see [S3 Table buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_list_table_buckets/](https://www.paws-r-sdk.com/docs/s3tables_list_table_buckets/) for full documentation.
#'
#' @param prefix The prefix of the table buckets.
#' @param continuationToken `ContinuationToken` indicates to Amazon S3 that the list is being
#' continued on this bucket with a token. `ContinuationToken` is obfuscated
#' and is not a real key. You can use this `ContinuationToken` for
#' pagination of the list results.
#' @param maxBuckets The maximum number of table buckets to return in the list.
#'
#' @keywords internal
#'
#' @rdname s3tables_list_table_buckets
s3tables_list_table_buckets <- function(prefix = NULL, continuationToken = NULL, maxBuckets = NULL) {
  op <- new_operation(
    name = "ListTableBuckets",
    http_method = "GET",
    http_path = "/buckets",
    host_prefix = "",
    paginator = list(input_token = "continuationToken", output_token = "continuationToken", limit_key = "maxBuckets", result_key = "tableBuckets"),
    stream_api = FALSE
  )
  input <- .s3tables$list_table_buckets_input(prefix = prefix, continuationToken = continuationToken, maxBuckets = maxBuckets)
  output <- .s3tables$list_table_buckets_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$list_table_buckets <- s3tables_list_table_buckets

#' List tables in the given table bucket
#'
#' @description
#' List tables in the given table bucket. For more information, see [S3 Tables](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_list_tables/](https://www.paws-r-sdk.com/docs/s3tables_list_tables/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon resource Name (ARN) of the table bucket.
#' @param namespace The namespace of the tables.
#' @param prefix The prefix of the tables.
#' @param continuationToken `ContinuationToken` indicates to Amazon S3 that the list is being
#' continued on this bucket with a token. `ContinuationToken` is obfuscated
#' and is not a real key. You can use this `ContinuationToken` for
#' pagination of the list results.
#' @param maxTables The maximum number of tables to return.
#'
#' @keywords internal
#'
#' @rdname s3tables_list_tables
s3tables_list_tables <- function(tableBucketARN, namespace = NULL, prefix = NULL, continuationToken = NULL, maxTables = NULL) {
  op <- new_operation(
    name = "ListTables",
    http_method = "GET",
    http_path = "/tables/{tableBucketARN}",
    host_prefix = "",
    paginator = list(input_token = "continuationToken", output_token = "continuationToken", limit_key = "maxTables", result_key = "tables"),
    stream_api = FALSE
  )
  input <- .s3tables$list_tables_input(tableBucketARN = tableBucketARN, namespace = namespace, prefix = prefix, continuationToken = continuationToken, maxTables = maxTables)
  output <- .s3tables$list_tables_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$list_tables <- s3tables_list_tables

#' Creates a new maintenance configuration or replaces an existing
#' maintenance configuration for a table bucket
#'
#' @description
#' Creates a new maintenance configuration or replaces an existing maintenance configuration for a table bucket. For more information, see [Amazon S3 table bucket maintenance](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_put_table_bucket_maintenance_configuration/](https://www.paws-r-sdk.com/docs/s3tables_put_table_bucket_maintenance_configuration/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket associated with the
#' maintenance configuration.
#' @param type &#91;required&#93; The type of the maintenance configuration.
#' @param value &#91;required&#93; Defines the values of the maintenance configuration for the table
#' bucket.
#'
#' @keywords internal
#'
#' @rdname s3tables_put_table_bucket_maintenance_configuration
s3tables_put_table_bucket_maintenance_configuration <- function(tableBucketARN, type, value) {
  op <- new_operation(
    name = "PutTableBucketMaintenanceConfiguration",
    http_method = "PUT",
    http_path = "/buckets/{tableBucketARN}/maintenance/{type}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$put_table_bucket_maintenance_configuration_input(tableBucketARN = tableBucketARN, type = type, value = value)
  output <- .s3tables$put_table_bucket_maintenance_configuration_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$put_table_bucket_maintenance_configuration <- s3tables_put_table_bucket_maintenance_configuration

#' Creates a new maintenance configuration or replaces an existing table
#' bucket policy for a table bucket
#'
#' @description
#' Creates a new maintenance configuration or replaces an existing table bucket policy for a table bucket. For more information, see [Adding a table bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-add) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_put_table_bucket_policy/](https://www.paws-r-sdk.com/docs/s3tables_put_table_bucket_policy/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#' @param resourcePolicy &#91;required&#93; The `JSON` that defines the policy.
#'
#' @keywords internal
#'
#' @rdname s3tables_put_table_bucket_policy
s3tables_put_table_bucket_policy <- function(tableBucketARN, resourcePolicy) {
  op <- new_operation(
    name = "PutTableBucketPolicy",
    http_method = "PUT",
    http_path = "/buckets/{tableBucketARN}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$put_table_bucket_policy_input(tableBucketARN = tableBucketARN, resourcePolicy = resourcePolicy)
  output <- .s3tables$put_table_bucket_policy_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$put_table_bucket_policy <- s3tables_put_table_bucket_policy

#' Creates a new maintenance configuration or replaces an existing
#' maintenance configuration for a table
#'
#' @description
#' Creates a new maintenance configuration or replaces an existing maintenance configuration for a table. For more information, see [S3 Tables maintenance](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_put_table_maintenance_configuration/](https://www.paws-r-sdk.com/docs/s3tables_put_table_maintenance_configuration/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table associated with the
#' maintenance configuration.
#' @param namespace &#91;required&#93; The namespace of the table.
#' @param name &#91;required&#93; The name of the maintenance configuration.
#' @param type &#91;required&#93; The type of the maintenance configuration.
#' @param value &#91;required&#93; Defines the values of the maintenance configuration for the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_put_table_maintenance_configuration
s3tables_put_table_maintenance_configuration <- function(tableBucketARN, namespace, name, type, value) {
  op <- new_operation(
    name = "PutTableMaintenanceConfiguration",
    http_method = "PUT",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/maintenance/{type}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$put_table_maintenance_configuration_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name, type = type, value = value)
  output <- .s3tables$put_table_maintenance_configuration_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$put_table_maintenance_configuration <- s3tables_put_table_maintenance_configuration

#' Creates a new maintenance configuration or replaces an existing table
#' policy for a table
#'
#' @description
#' Creates a new maintenance configuration or replaces an existing table policy for a table. For more information, see [Adding a table policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-add) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_put_table_policy/](https://www.paws-r-sdk.com/docs/s3tables_put_table_policy/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket that contains the
#' table.
#' @param namespace &#91;required&#93; The namespace associated with the table.
#' @param name &#91;required&#93; The name of the table.
#' @param resourcePolicy &#91;required&#93; The `JSON` that defines the policy.
#'
#' @keywords internal
#'
#' @rdname s3tables_put_table_policy
s3tables_put_table_policy <- function(tableBucketARN, namespace, name, resourcePolicy) {
  op <- new_operation(
    name = "PutTablePolicy",
    http_method = "PUT",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$put_table_policy_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name, resourcePolicy = resourcePolicy)
  output <- .s3tables$put_table_policy_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$put_table_policy <- s3tables_put_table_policy

#' Renames a table or a namespace
#'
#' @description
#' Renames a table or a namespace. For more information, see [S3 Tables](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html) in the *Amazon Simple Storage Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_rename_table/](https://www.paws-r-sdk.com/docs/s3tables_rename_table/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#' @param namespace &#91;required&#93; The namespace associated with the table.
#' @param name &#91;required&#93; The current name of the table.
#' @param newNamespaceName The new name for the namespace.
#' @param newName The new name for the table.
#' @param versionToken The version token of the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_rename_table
s3tables_rename_table <- function(tableBucketARN, namespace, name, newNamespaceName = NULL, newName = NULL, versionToken = NULL) {
  op <- new_operation(
    name = "RenameTable",
    http_method = "PUT",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/rename",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$rename_table_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name, newNamespaceName = newNamespaceName, newName = newName, versionToken = versionToken)
  output <- .s3tables$rename_table_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$rename_table <- s3tables_rename_table

#' Updates the metadata location for a table
#'
#' @description
#' Updates the metadata location for a table. The metadata location of a table must be an S3 URI that begins with the table's warehouse location. The metadata location for an Apache Iceberg table must end with `.metadata.json`, or if the metadata file is Gzip-compressed, `.metadata.json.gz`.
#'
#' See [https://www.paws-r-sdk.com/docs/s3tables_update_table_metadata_location/](https://www.paws-r-sdk.com/docs/s3tables_update_table_metadata_location/) for full documentation.
#'
#' @param tableBucketARN &#91;required&#93; The Amazon Resource Name (ARN) of the table bucket.
#' @param namespace &#91;required&#93; The namespace of the table.
#' @param name &#91;required&#93; The name of the table.
#' @param versionToken &#91;required&#93; The version token of the table.
#' @param metadataLocation &#91;required&#93; The new metadata location for the table.
#'
#' @keywords internal
#'
#' @rdname s3tables_update_table_metadata_location
s3tables_update_table_metadata_location <- function(tableBucketARN, namespace, name, versionToken, metadataLocation) {
  op <- new_operation(
    name = "UpdateTableMetadataLocation",
    http_method = "PUT",
    http_path = "/tables/{tableBucketARN}/{namespace}/{name}/metadata-location",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .s3tables$update_table_metadata_location_input(tableBucketARN = tableBucketARN, namespace = namespace, name = name, versionToken = versionToken, metadataLocation = metadataLocation)
  output <- .s3tables$update_table_metadata_location_output()
  config <- get_config()
  svc <- .s3tables$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3tables$operations$update_table_metadata_location <- s3tables_update_table_metadata_location
