% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UndClassFunctions.R
\name{print.UndPCDs}
\alias{print.UndPCDs}
\title{Print a \code{UndPCDs} \code{object}}
\usage{
\method{print}{UndPCDs}(x, ...)
}
\arguments{
\item{x}{An \code{UndPCDs} \code{object}.}

\item{\dots}{Additional arguments for the S3 method \code{'print'}.}
}
\value{
The \code{call} of the \code{object} of class \code{"UndPCDs"}
and also the \code{type} (i.e. a brief description)
of  the underlying or reflexivity graphs of the proximity catch digraph (PCD).
}
\description{
Prints the \code{call} of the \code{object}
of class \code{"UndPCDs"}
and also the \code{type} (i.e. a brief description)
of the underlying and reflexivity graphs of the proximity catch digraph (PCD).
}
\examples{
#\donttest{
nx<-20; ny<-5;
set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
M<-c(1,1,1)  #try also M<-c(1,2,3)
r<-1.5
Edges<-edgesPE(Xp,Yp,r,M)
Edges
print(Edges)

typeof(Edges)
attributes(Edges)
#}

}
\seealso{
\code{\link{summary.UndPCDs}},
\code{\link{print.summary.UndPCDs}},
and \code{\link{plot.UndPCDs}}
}
