% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C_pl.R
\name{C_pl}
\alias{C_pl}
\title{\eqn{C_{pl}}}
\usage{
C_pl(mu, sigma, lsl, l)
}
\arguments{
\item{mu}{\code{numeric}.}

\item{sigma}{\code{numeric}.}

\item{lsl}{\code{numeric}.}

\item{l}{\code{numeric}. Conventionally set to 3. Must be greater than 0.}
}
\value{
\code{double}.
}
\description{
\deqn{C_{pl} = \frac{\mu - \text{LSL}}{L \sigma}}

Note. This function allows for negative \eqn{C_{pl}} values.

Only vectors of length 1 are recycled.

\code{NA}'s take precedence over \code{NaN}'s, e.g. \code{NaN + NA} will output \code{NA}.

Yields \code{NaN} if \code{sigma} equals 0.
}
\examples{
set.seed(1L)
data = rnorm(n = 30L, mean = 3., sd = 1.)
C_pl(mu = mean(data), sigma = sd(data), lsl = 0., l = 3.)
# [1] 1.111853

}
\references{
Montgomery, D. C. (2019). \emph{Introduction to statistical quality  control} (8th ed.). Wiley. ISBN: 978-1-119-39930-8
}
\seealso{
\code{\link[=C_pu]{C_pu()}}, \code{\link[=C_pk]{C_pk()}}
}
