% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C_pu.R
\name{C_pu}
\alias{C_pu}
\title{\eqn{C_{pu}}}
\usage{
C_pu(mu, sigma, usl, l)
}
\arguments{
\item{mu}{\code{numeric}.}

\item{sigma}{\code{numeric}.}

\item{usl}{\code{numeric}.}

\item{l}{\code{numeric}. Conventionally set to 3. Must be greater than 0.}
}
\value{
\code{double}.
}
\description{
\deqn{C_{pu} = \frac{\text{USL} - \mu}{L \sigma}}

Note. This function allows for negative \eqn{C_{pu}} values.

Only vectors of length 1 are recycled.

\code{NA}'s take precedence over \code{NaN}'s, e.g. \code{NaN + NA} will output \code{NA}.

Yields \code{NaN} if \code{sigma} equals 0.
}
\examples{
set.seed(1L)
data = rnorm(n = 30L, mean = 3., sd = 1.)
C_pu(mu = mean(data), sigma = sd(data), usl = 6., l = 3.)
# [1] 1.052367

}
\references{
Montgomery, D. C. (2019). \emph{Introduction to statistical quality  control} (8th ed.). Wiley. ISBN: 978-1-119-39930-8
}
\seealso{
\code{\link[=C_pl]{C_pl()}}, \code{\link[=C_pk]{C_pk()}}
}
