% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Tutankhamun}
\alias{Tutankhamun}
\title{Pedigree of Tutankhamun}
\format{
A data frame with 7 rows and 12 columns:
\itemize{
\item \code{id},\code{fid},\code{mid},\code{sex}: Pedigree columns in standard format
\item \code{D13S317}, ...: Genotype columns for 8 markers
}
}
\source{
Hawass et al. \emph{Ancestry and pathology in King Tutankhamun's family}.
Jama (2010).
}
\usage{
Tutankhamun
}
\description{
A reconstructed pedigree of the Egyptian Pharaoh Tutankhamun, with genotypes
for 8 STR markers, as published by Hawass et al.
}
\examples{
# Pedigree as published
plot(Tutankhamun)

# Simple reconstruction, assuming all directly related
res = reconstruct(Tutankhamun, extra = 0, inferPO = TRUE, maxInbreeding = 1)
plot(res, top = 4)

# Published ped is most likely (with these assumptions)
identical(res[[1]], Tutankhamun)

}
\keyword{datasets}
