% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_distribute.R
\name{distributeMarkers}
\alias{distributeMarkers}
\title{Distribute markers evenly along a set of chromosomes}
\usage{
distributeMarkers(
  x,
  n = NULL,
  dist = NULL,
  chromLen = NULL,
  alleles = 1:2,
  afreq = NULL,
  prefix = "M"
)
}
\arguments{
\item{x}{A ped object.}

\item{n}{The total number of markers. Either this or \code{dist} must be NULL.}

\item{dist}{A positive number; the distance (in megabases) between markers.}

\item{chromLen}{A numeric vector indicating chromosome lengths (in Mb). By
default, the lengths of the human chromosomes 1-22 are used, as returned by
\code{sapply(ibdsim2::loadMap("decode"), ibdsim2::physRange)}.}

\item{alleles, afreq}{Passed onto \code{\link[=marker]{marker()}}.}

\item{prefix}{A string used as prefix for marker names. Default: "M".}
}
\value{
A copy of \code{x} with the indicated markers attached.
}
\description{
Create and attach identical (empty) marker objects, distributed along a set
of chromosomes.
}
\details{
Note: When using the \code{dist} parameter, the function treats each chromosome
separately, places one marker at the start and then every \code{dist} megabases.
(See Examples.)
}
\examples{
x = distributeMarkers(nuclearPed(), n = 10)
getMap(x)

y = distributeMarkers(nuclearPed(), dist = 100)
getMap(y)
}
