% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_plot.R
\name{plotPedList}
\alias{plotPedList}
\title{Plot a collection of pedigrees.}
\usage{
plotPedList(
  plots,
  widths = NULL,
  groups = NULL,
  titles = NULL,
  grouptitlesArgs = NULL,
  frames = TRUE,
  fmar = NULL,
  source = NULL,
  dev.height = NULL,
  dev.width = NULL,
  newdev = !is.null(dev.height) || !is.null(dev.width),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{plots}{A list of lists. Each element of \code{plots} is a list, where the
first element is a pedigree, and the remaining elements are passed on to
\code{plot.ped}. These elements must be correctly named. See examples below.}

\item{widths}{A numeric vector of relative widths of the subplots. Recycled
to \code{length(plots)} if necessary, before passed on to \code{\link[=layout]{layout()}}. Note that
the vector does not need to sum to 1.}

\item{groups}{A list of vectors, each consisting of consecutive integers,
indicating subplots to be grouped. By default the grouping follows the list
structure of \code{plots}.}

\item{titles}{A character vector of titles for each group. Overrides titles
given in individuals subplots.}

\item{grouptitlesArgs}{A list of arguments passed on to \code{\link[=mtext]{mtext()}} for
\code{titles}.}

\item{frames}{A logical indicating if groups should be framed.}

\item{fmar}{A single number in the interval \eqn{[0,0.5)} controlling the
position of the frames.}

\item{source}{NULL (default), or the name or index of an element of \code{plots}.
If given, marker data is temporarily transferred from this to all the other
pedigrees. This may save some typing when plotting the same genotypes on
several pedigrees.}

\item{dev.height, dev.width}{The dimensions of the new plot window. If these
are NA suitable values are guessed from the pedigree sizes.}

\item{newdev}{A logical, indicating if a new plot window should be opened.}

\item{verbose}{A logical.}

\item{\dots}{Further arguments passed on to each call to \code{\link[=plot.ped]{plot.ped()}}.}
}
\description{
This function creates a row of pedigree plots, each created by \code{\link[=plot.ped]{plot.ped()}}.
Any parameter accepted by \code{\link[=plot.ped]{plot.ped()}} can be applied, either to all plots
simultaneously, or to individual plots.  Some effort is made to guess a
reasonable window size and margins, but in general the user must be prepared
to do manual resizing of the plot window. See various examples in the
Examples section below.
}
\details{
Note that for tweaking dev.height and dev.width the function \code{\link[=dev.size]{dev.size()}} is
useful to determine the size of the active device.
}
\examples{
##################
# Basic examples #
##################

# Simples use: Just give a list of ped objects.
peds = list(nuclearPed(3), cousinPed(2), singleton(12), halfSibPed())
plotPedList(peds, newdev = TRUE)

# Override automatic determination of relative widths
w = c(2, 3, 1, 2)
plotPedList(peds, widths = w)

# In most cases the guessed dimensions are ok but not perfect.
# Resize plot window manually and re-plot with `newdev = FALSE` (default)
# plotPedList(peds, widths = w)

## Remove frames
plotPedList(peds, widths = w, frames = FALSE)

# Non-default grouping
plotPedList(peds, widths = w, groups = list(1, 2:3, 4), titles = 1:3)

# Parameters added in the main call are used in each sub-plot
plotPedList(peds, widths = w, labs = leaves, hatched = leaves,
            col = list(blue = males, red = females), symbolsize = 1.3)

dev.off()

#################################
# Example of automatic grouping #
#################################
H1 = nuclearPed()
H2 = singletons(id = c(1,3))

plotPedList(list(H1, H2), dev.height = 3, dev.width = 4,
            titles = c(expression(H[1]), expression(H[2])),
            cex = 1.5, cex.main = 1.3)

dev.off()

############################################################
# Complex example with individual parameters for each plot #
############################################################

# For more control of individual plots, each plot and all
# its parameters can be specified in its own list.

x1 = nuclearPed(nch = 3) |>
  addMarker(`3` = "1/2")
plot1 = list(x1, title = "Plot 1", marker = 1, deceased = 1:2, cex = 1.3,
             margins = c(7, 4, 7, 4))

x2 = cousinPed(2) |>
  addMarker(`11` = "A/A", `12` = "A/A")
plot2 = list(x2, title = "Family", marker = 1, symbolsize = 1.2, labs = NULL,
             margins = c(3, 4, 2, 4))

x3 = singleton("NN")
plot3 = list(x3, cex = 2, carrier = "NN", lty = c(NN = 2))

x4 = halfSibPed()
plot4 = list(x4, title = "Half sibs", cex = 1.3, hatched = leaves,
             col = list(red = founders), fill = list(blue = leaves),
             margins = c(7, 4, 7, 4))

plotPedList(list(plot1, plot2, plot3, plot4), widths = c(2,3,1,2),
            fmar = 0.03, groups = list(1, 2:3, 4), newdev = TRUE,
            cex.main = 1.5)

dev.off()

################################
# Example with large pedigrees #
################################

# Important to set device dimensions here

plotPedList(list(halfCousinPed(4), cousinPed(7)),
            titles = c("Large", "Very large"), widths = c(1, 1.3),
            dev.height = 8, dev.width = 6, margins = 1.5)

dev.off()

}
\seealso{
\code{\link[=plot.ped]{plot.ped()}}
}
\author{
Magnus Dehli Vigeland
}
