#' Pell Grant Data
#'
#' Total dollar amount awarded as Pell grant by different colleges over the years.
#'
#' @format A data frame with six variables:
#' \describe{
#' \item{\code{STATE}}{Name of the state of the respective institution}
#' \item{\code{AWARD}}{Total dollar value of awarded pell grant by the respective institution}
#' \item{\code{RECIPIENT}}{Total number of pell grant recipients at that institution}
#' \item{\code{NAME}}{Name of the college/university}
#' \item{\code{SESSION}}{Academic session when the grant was awarded}
#' \item{\code{YEAR}}{Fiscal year of when the grant was awarded}
#'}
#' @source {US Department of Education: } \url{https://www2.ed.gov/finaid/prof/resources/data/pell-institution.html}
#'
#' For further details about the federal Pell grant program, see \url{https://www2.ed.gov/programs/fpg/index.html}
#'
"pell"

