% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_mlpmms.R
\name{summarize_mlpmms}
\alias{summarize_mlpmms}
\title{Step 2 of PRC-MLPMM (computation of the predicted random effects)}
\usage{
summarize_mlpmms(object, n.cores = 1, verbose = TRUE)
}
\arguments{
\item{object}{a list of objects as produced by \code{\link{fit_mlpmms}}}

\item{n.cores}{number of cores to use to parallelize part of
the computations. If \code{ncores = 1} (default), no parallelization is done. 
Pro tip: you can use \code{parallel::detectCores()} to check 
how many cores are available on your computer}

\item{verbose}{if \code{TRUE} (default and recommended value), information
on the ongoing computations is printed in the console}
}
\value{
A list containing the following objects:
\itemize{
\item \code{call}: the function call
\item \code{ranef.orig}: a matrix with the predicted random effects
computed for the original data;
\item \code{n.boots}: number of bootstrap samples;
\item \code{boot.ids}: a list with the ids of bootstrapped subjects 
(when \code{n.boots > 0});
\item \code{ranef.boot.train}: a list where each element is a matrix that 
contains the predicted random effects for each bootstrap sample 
(when \code{n.boots > 0});
\item \code{ranef.boot.valid}: a list where each element is a matrix that 
contains the predicted random effects on the original data, based on the 
mlpmms fitted on the cluster bootstrap samples (when \code{n.boots > 0});
}
}
\description{
This function performs the second step for the estimation
of the PRC-MLPMM model proposed in Signorelli et al. (2021)
}
\examples{
\donttest{
# generate example data
set.seed(123)
n.items = c(4,2,2,3,4,2)
simdata = simulate_prcmlpmm_data(n = 100, p = length(n.items),  
             p.relev = 3, n.items = n.items, 
             type = 'u+b', seed = 1)
 
# specify options for cluster bootstrap optimism correction
# procedure and for parallel computing 
do.bootstrap = FALSE
# IMPORTANT: set do.bootstrap = TRUE to compute the optimism correction!
n.boots = ifelse(do.bootstrap, 100, 0)
more.cores = FALSE
# IMPORTANT: set more.cores = TRUE to speed computations up!
if (!more.cores) n.cores = 2
if (more.cores) {
   # identify number of available cores on your machine
   n.cores = parallel::detectCores()
   if (is.na(n.cores)) n.cores = 2
}

# step 1 of PRC-MLPMM: estimate the MLPMMs
y.names = vector('list', length(n.items))
for (i in 1:length(n.items)) {
  y.names[[i]] = paste('marker', i, '_', 1:n.items[i], sep = '')
}

step1 = fit_mlpmms(y.names, fixefs = ~ contrast(age),  
                 ranef.time = age, randint.items = TRUE, 
                 long.data = simdata$long.data, 
                 surv.data = simdata$surv.data,
                 t.from.base = t.from.base,
                 n.boots = n.boots, n.cores = n.cores)

# step 2 of PRC-MLPMM: compute the summaries 
step2 = summarize_mlpmms(object = step1, n.cores = n.cores)
summary(step2)
}
}
\references{
Signorelli, M. (2024). pencal: an R Package for the Dynamic 
Prediction of Survival with Many Longitudinal Predictors. 
The R Journal, 16 (2), 134-153.

Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. Statistics in Medicine, 40 (27), 6178-6196.
}
\seealso{
\code{\link{fit_mlpmms}} (step 1), 
\code{\link{fit_prcmlpmm}} (step 3),
\code{\link{performance_prc}}
}
\author{
Mirko Signorelli
}
