% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timesToSeconds.R
\name{convertToSeconds}
\alias{convertToSeconds}
\title{Convert Time to Seconds.}
\usage{
convertToSeconds(hours, minutes, seconds, HHMMSS, HHMM, MMSS)
}
\arguments{
\item{hours}{Character vector of the number of hours.}

\item{minutes}{Character vector of the number of minutes.}

\item{seconds}{Character vector of the number of seconds.}

\item{HHMMSS}{Times in HH:MM:SS format.}

\item{HHMM}{Character vector of times in HH:MM format.}

\item{MMSS}{Character vector of times in MM:SS format.}
}
\value{
Vector of times in seconds.
}
\description{
Convert times to seconds.
}
\details{
Converts times to seconds. To convert times to hours or minutes, see
\link{convertToHours} or \link{convertToMinutes}.
}
\examples{
# Prepare Data
df <- data.frame(hours = c(0,1), minutes = c(15,27), seconds = c(30,13),
  HHMMSS = c("00:15:30","01:27:13"), HHMM = c("00:15","01:27"),
  MMSS = c("15:30","87:13"))

# Convert to Minutes
convertToSeconds(hours = df$hours, minutes = df$minutes,
  seconds = df$seconds)
convertToSeconds(HHMMSS = df$HHMMSS)
convertToSeconds(HHMM = df$HHMM)
convertToSeconds(MMSS = df$MMSS)
}
\seealso{
Other times: 
\code{\link{convertHoursAMPM}()},
\code{\link{convertToHours}()},
\code{\link{convertToMinutes}()}

Other conversion: 
\code{\link{convert.magic}()},
\code{\link{convertHoursAMPM}()},
\code{\link{convertToHours}()},
\code{\link{convertToMinutes}()},
\code{\link{percentileToTScore}()},
\code{\link{pom}()}
}
\concept{conversion}
\concept{times}
