% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laja.R
\docType{data}
\name{laja}
\alias{laja}
\alias{invert.traits}
\alias{invert.tree}
\alias{river.env}
\alias{river.sites}
\title{Macroinvertebrate samples from the Rio Laja of Mexico}
\format{
\code{laja} contains a \code{\link[ape]{phylo}} object, a
dataframe of sites-by-taxa, a dataframe of sites-by-environment,
and a dataframe of traits
}
\usage{
data(laja)
}
\description{
This data set includes macroinvertebrate samples from
the Rio Laja, a phylogenetic tree of the taxa and traits that
include mean body length and fish feeding preference as in Helmus
\emph{et al.} 2013.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits, river.env)
}
\references{
Helmus M., Mercado-Silva N. & Vander Zanden
M.J. (2013). Subsidies to predators, apparent competition and the
phylogenetic structure of prey communities. Oecologia, 173,
997-1007.
}
\author{
M.R. Helmus
}
\keyword{datasets}
