% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{bin_observations}
\alias{bin_observations}
\title{bin_observations}
\usage{
bin_observations(model, method, nbins)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{method}{(str) Name of the binning method to use}

\item{nbins}{(numeric) The number of bins wanted}
}
\value{
(data.frame) A series of bin ids indexed on the original record index of the dataset vector A vector of bin edges
}
\description{
Bin all observations on the independent variable

Available binning methods:

+---------------+-------------------------------------------------+
| Method        | Description                                     |
+===============+=================================================+
| equal_width   | Bins with equal width based on the idv          |
+---------------+-------------------------------------------------+
| equal_number  | Bins containing an equal number of observations |
+---------------+-------------------------------------------------+
}
\examples{
\dontrun{
model <- load_example_model("pheno")
bins, boundaries <- bin_observations(model, method="equal_width", nbins=10)
bins
boundaries
}

}
