% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{sample_parameters_uniformly}
\alias{sample_parameters_uniformly}
\title{sample_parameters_uniformly}
\usage{
sample_parameters_uniformly(
  model,
  parameter_estimates,
  fraction = 0.1,
  force_posdef_samples = NULL,
  n = 1,
  seed = 1234,
  scale = "normal"
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{parameter_estimates}{(array) Parameter estimates for parameters to use}

\item{fraction}{(numeric) Fraction of estimate value to use for distribution bounds}

\item{force_posdef_samples}{(numeric (optional)) Number of samples to reject before forcing variability parameters to give
positive definite covariance matrices.}

\item{n}{(numeric) Number of samples}

\item{seed}{(numeric) Random number generator or seed}

\item{scale}{(str) Scale to perform sampling on. Valid options are 'normal' and 'UCP'}
}
\value{
(data.frame) samples
}
\description{
Sample parameter vectors using uniform sampling

Each parameter value will be randomly sampled from a uniform distribution
with the bounds being estimate ± estimate * fraction.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
rng <- create_rng(23)
pe <- results$parameter_estimates
sample_parameters_uniformly(model, pe, n=3, seed=rng)
}
}
\seealso{
sample_parameters_from_covariance_matrix : Sample parameter vectors using the

uncertainty covariance matrix

sample_individual_estimates : Sample individual estiates given their covariance
}
