% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi_delta.R
\name{iso_sensitivity}
\alias{iso_sensitivity}
\title{isometric sensitivity lines}
\usage{
iso_sensitivity(ratio = 1, granularity = 0.25, col = "blue",
  lty = "longdash", ...)
}
\arguments{
\item{ratio}{numeric value for the ratio of positive and negative of the data}

\item{granularity}{numeric value between 0 and 1 for the granularity of the lines.
It is a value for the distance between 2 lines}

\item{col}{the color of the lines}

\item{lty}{the type of line, see \link{par}}

\item{...}{further graphical parameters, see \link{par}}
}
\description{
adds isometric lines for the sensitivity to the plot depending on the ratio
}
\examples{
x <- c_statistics(climate_data)
ratio <- calculate_ratio(x)
phiDelta_plot_from_data(x)
iso_sensitivity(ratio, col = "green")
}
\author{
Neumann
}
