% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phraseDoc.R
\name{phraseDoc}
\alias{phraseDoc}
\title{phraseDoc Creation}
\usage{
phraseDoc(
  text,
  ids = NULL,
  mn = 2,
  mx = 8,
  ssw = stopStartWords(),
  sew = stopEndWords(),
  sp = stopPhrases(),
  min.freq = 2,
  max.phrases = 1500,
  shiny = FALSE,
  silent = TRUE
)
}
\arguments{
\item{text}{a character vector with each element the text of a document, or 
a corpus}

\item{ids}{a character vector with identifiers for each text}

\item{mn}{Minimum number of words in a phrase.}

\item{mx}{Maximum number of words in a phrase.}

\item{ssw}{A set of words no phrase should start with.}

\item{sew}{A set of words no phrase should end with.}

\item{sp}{A set of phrases to be excluded.}

\item{min.freq}{The minimum frequency of phrases to be included.}

\item{max.phrases}{Maximum number of phrases to be included.}

\item{shiny}{TRUE if called from a shiny program. This will allow progress
to be recorded on a progress meter; the function uses about 100 progress
steps, so it should be created inside a withProgress function with the 
argument max set to at least 100.}

\item{silent}{TRUE if you do not want progress messages.}
}
\value{
Object of class phraseDoc
}
\description{
Create an object of class phraseDoc. This will hold all principal phrases of
a collection of texts that occur a minimum number of times, plus the texts
they occur in and their position within those texts.
}
\examples{
tst=c("This is a test text",
      "This is a test text 2",
      "This is another test text",
      "This is another test text 2",
      "This girl will test text that man",
      "This boy will test text that man")
phraseDoc(tst)
}
