#' @title apogee broadband sensors
#'
#' @description A vector of indexes for extracting subsets of spectra from the
#' \code{\link{sensors.mspct}} object.
#'
#' @format A character vector of names of members of the collection of spectra.
#'
#' @docType data
#' @keywords datasets
#'
#' @details
#' apogee SQ-100X-SS: Original Quantum Sensor.
#'
#' apogee SQ-500-SS: Full-Spectrum Quantum Sensor
#'
#' apogee SQ-610-SS 400-750nm ePAR Sensor (extended PAR quantum)
#'
#' apogee SU-200-SS: UV-A Sensor (UV-A, "energy")
#'
#' apogee S2-131-SS Red and Far-Red Sensor, Red channel, quantum
#'
#' apogee S2-131-SS Red and Far-Red Sensor, Far-Red channel, quantum
#'
#'
#' @note
#' Digitized with 'DigitizeIt' from manufacturers product on-line
#' specifications. This are approximate data, both because of the digitizing
#' process from low resolution bitmaps, and because they are either typical
#' values or for a particular sensor unit. Individual sensor units are expected
#' to differ to some degree in spectral response.
#'
#' Manufacturer: Apogee Instruments, Inc., Logan, UT, USA.
#'
#' @references \url{https://www.apogeeinstruments.com/quantum/}
#' visited on 2023-10-10.
#'
#' @examples
#'
#' apogee_sensors
#'
"apogee_sensors"
