% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.solar.spectra.data.r
\docType{data}
\name{sun_hourly_ozone.spct}
\alias{sun_hourly_ozone.spct}
\title{Ground level spectral irradiance at hourly intervals}
\format{
A \code{source_spct} containing 32 spectra in long form (293 nm to
  800 nm at 1 nm interval) and 6 variables.
}
\usage{
sun_hourly_ozone.spct
}
\description{
Datasets containing the wavelengths at 1.0 nm interval and tabulated values
of spectral irradiance for the sun for 21 May, at Jokioinen, Finland, under
climatology-based mean ozone column and with a 20% depletion. Simulated with
'libradtran' assuming clear sky.
}
\details{
The variables are as follows: 
\itemize{ 
\item w.length numeric (nm).
\item s.e.irrad numeric (W m-2 nm-1).
\item UTC POSIXct (UTC date and time).
\item ozone Factor with two levels.
\item sun.elevation Angle above the astronomical horizon (degrees).
\item spct.idx factor with one level per spectrum.
}
The data set includes spectra for day-time, not 24 h.
}
\note{
The simulation methods has been described in Lindfors et al. (2009).
}
\examples{
e_irrad(sun_hourly_ozone.spct)
wl_range(sun_hourly_ozone.spct)
getMultipleWl(sun_hourly_ozone.spct) # number of spectra

}
\references{
Lindfors, A.; Heikkilä, A.; Kaurola, J.; Koskela, T. & Lakkala, K. (2009) 
Reconstruction of Solar Spectral Surface UV Irradiances Using Radiative 
Transfer Simulations. Photochemistry and Photobiology, 85: 1233-1239
}
\author{
Anders K. Lindfors (radiation transfer modelling).
}
\keyword{datasets}
