// Generated by rstantools.  Do not edit by hand.

/*
    phylopairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    phylopairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phylopairs.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_betareg_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 77> locations_array__ =
  {" (found before start of program)",
  " (in 'betareg', line 19, column 2 to column 17)",
  " (in 'betareg', line 20, column 2 to column 20)",
  " (in 'betareg', line 22, column 2 to column 58)",
  " (in 'betareg', line 23, column 2 to column 47)",
  " (in 'betareg', line 26, column 2 to column 16)",
  " (in 'betareg', line 59, column 2 to column 19)",
  " (in 'betareg', line 60, column 2 to column 15)",
  " (in 'betareg', line 31, column 4 to column 19)",
  " (in 'betareg', line 30, column 9 to line 32, column 3)",
  " (in 'betareg', line 29, column 4 to column 34)",
  " (in 'betareg', line 28, column 23 to line 30, column 3)",
  " (in 'betareg', line 28, column 2 to line 32, column 3)",
  " (in 'betareg', line 71, column 4 to column 25)",
  " (in 'betareg', line 70, column 31 to line 72, column 3)",
  " (in 'betareg', line 70, column 9 to line 72, column 3)",
  " (in 'betareg', line 69, column 4 to column 28)",
  " (in 'betareg', line 68, column 31 to line 70, column 3)",
  " (in 'betareg', line 68, column 9 to line 72, column 3)",
  " (in 'betareg', line 66, column 6 to column 40)",
  " (in 'betareg', line 65, column 19 to line 67, column 5)",
  " (in 'betareg', line 65, column 4 to line 67, column 5)",
  " (in 'betareg', line 64, column 31 to line 68, column 3)",
  " (in 'betareg', line 64, column 9 to line 72, column 3)",
  " (in 'betareg', line 63, column 4 to column 24)",
  " (in 'betareg', line 62, column 24 to line 64, column 3)",
  " (in 'betareg', line 62, column 2 to line 72, column 3)",
  " (in 'betareg', line 75, column 4 to column 65)",
  " (in 'betareg', line 74, column 17 to line 76, column 3)",
  " (in 'betareg', line 74, column 2 to line 76, column 3)",
  " (in 'betareg', line 36, column 2 to column 36)",
  " (in 'betareg', line 37, column 2 to column 35)",
  " (in 'betareg', line 39, column 4 to column 50)",
  " (in 'betareg', line 40, column 4 to column 70)",
  " (in 'betareg', line 38, column 23 to line 41, column 3)",
  " (in 'betareg', line 38, column 2 to line 41, column 3)",
  " (in 'betareg', line 43, column 9 to column 10)",
  " (in 'betareg', line 43, column 2 to column 15)",
  " (in 'betareg', line 53, column 4 to column 25)",
  " (in 'betareg', line 52, column 31 to line 54, column 3)",
  " (in 'betareg', line 52, column 9 to line 54, column 3)",
  " (in 'betareg', line 51, column 4 to column 28)",
  " (in 'betareg', line 50, column 31 to line 52, column 3)",
  " (in 'betareg', line 50, column 9 to line 54, column 3)",
  " (in 'betareg', line 48, column 6 to column 40)",
  " (in 'betareg', line 47, column 19 to line 49, column 5)",
  " (in 'betareg', line 47, column 4 to line 49, column 5)",
  " (in 'betareg', line 46, column 31 to line 50, column 3)",
  " (in 'betareg', line 46, column 9 to line 54, column 3)",
  " (in 'betareg', line 45, column 4 to column 24)",
  " (in 'betareg', line 44, column 24 to line 46, column 3)",
  " (in 'betareg', line 44, column 2 to line 54, column 3)",
  " (in 'betareg', line 56, column 2 to column 37)",
  " (in 'betareg', line 4, column 2 to column 17)",
  " (in 'betareg', line 5, column 2 to column 17)",
  " (in 'betareg', line 6, column 26 to column 27)",
  " (in 'betareg', line 6, column 2 to column 31)",
  " (in 'betareg', line 7, column 9 to column 10)",
  " (in 'betareg', line 7, column 12 to column 13)",
  " (in 'betareg', line 7, column 2 to column 17)",
  " (in 'betareg', line 8, column 9 to column 10)",
  " (in 'betareg', line 8, column 12 to column 13)",
  " (in 'betareg', line 8, column 2 to column 18)",
  " (in 'betareg', line 9, column 2 to column 17)",
  " (in 'betareg', line 10, column 2 to column 24)",
  " (in 'betareg', line 11, column 2 to column 26)",
  " (in 'betareg', line 12, column 2 to column 25)",
  " (in 'betareg', line 13, column 2 to column 17)",
  " (in 'betareg', line 14, column 2 to column 15)",
  " (in 'betareg', line 15, column 2 to column 36)",
  " (in 'betareg', line 16, column 2 to column 35)",
  " (in 'betareg', line 19, column 9 to column 10)",
  " (in 'betareg', line 22, column 8 to column 31)",
  " (in 'betareg', line 23, column 9 to column 32)",
  " (in 'betareg', line 26, column 9 to column 10)",
  " (in 'betareg', line 59, column 9 to column 10)",
  " (in 'betareg', line 60, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_betareg final : public model_base_crtp<model_betareg> {
private:
  int N;
  int K;
  Eigen::Matrix<double,-1,1> Y_data__;
  Eigen::Matrix<double,-1,-1> X_data__;
  Eigen::Matrix<double,-1,-1> Cp_data__;
  double coef_mean;
  double coef_sd;
  double phi_shape;
  double phi_rate;
  double sig2_mean;
  double sig2_sd;
  int link_choice;
  int model_type;
  int sig2_scale_1dim__;
  int pair_effects_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> Y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Cp{nullptr, 0, 0};
public:
  ~model_betareg() {}
  model_betareg(stan::io::var_context& context__, unsigned int
                random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_betareg_namespace::model_betareg";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 53;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 53;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 53;
      stan::math::check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 54;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 54;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 54;
      stan::math::check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 55;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 56;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      Y_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                   std::numeric_limits<double>::quiet_NaN());
      new (&Y) Eigen::Map<Eigen::Matrix<double,-1,1>>(Y_data__.data(), N);
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 56;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 56;
          stan::model::assign(Y, Y_flat__[(pos__ - 1)],
            "assigning variable Y", stan::model::index_uni(sym1__));
          current_statement__ = 56;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 56;
      stan::math::check_greater_or_equal(function__, "Y", Y, 0);
      current_statement__ = 56;
      stan::math::check_less_or_equal(function__, "Y", Y, 1);
      current_statement__ = 57;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 58;
      stan::math::validate_non_negative_index("X", "K", K);
      current_statement__ = 59;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), N, K);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 59;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 59;
        pos__ = 1;
        current_statement__ = 59;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 59;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 59;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 59;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 60;
      stan::math::validate_non_negative_index("Cp", "N", N);
      current_statement__ = 61;
      stan::math::validate_non_negative_index("Cp", "N", N);
      current_statement__ = 62;
      context__.validate_dims("data initialization", "Cp", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(N)});
      Cp_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, N,
                    std::numeric_limits<double>::quiet_NaN());
      new (&Cp) Eigen::Map<Eigen::Matrix<double,-1,-1>>(Cp_data__.data(), N,
        N);
      {
        std::vector<local_scalar_t__> Cp_flat__;
        current_statement__ = 62;
        Cp_flat__ = context__.vals_r("Cp");
        current_statement__ = 62;
        pos__ = 1;
        current_statement__ = 62;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 62;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 62;
            stan::model::assign(Cp, Cp_flat__[(pos__ - 1)],
              "assigning variable Cp", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 62;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 63;
      context__.validate_dims("data initialization", "coef_mean", "double",
        std::vector<size_t>{});
      coef_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 63;
      coef_mean = context__.vals_r("coef_mean")[(1 - 1)];
      current_statement__ = 64;
      context__.validate_dims("data initialization", "coef_sd", "double",
        std::vector<size_t>{});
      coef_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 64;
      coef_sd = context__.vals_r("coef_sd")[(1 - 1)];
      current_statement__ = 64;
      stan::math::check_greater_or_equal(function__, "coef_sd", coef_sd, 0);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "phi_shape", "double",
        std::vector<size_t>{});
      phi_shape = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 65;
      phi_shape = context__.vals_r("phi_shape")[(1 - 1)];
      current_statement__ = 65;
      stan::math::check_greater_or_equal(function__, "phi_shape", phi_shape,
        0);
      current_statement__ = 66;
      context__.validate_dims("data initialization", "phi_rate", "double",
        std::vector<size_t>{});
      phi_rate = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 66;
      phi_rate = context__.vals_r("phi_rate")[(1 - 1)];
      current_statement__ = 66;
      stan::math::check_greater_or_equal(function__, "phi_rate", phi_rate, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "sig2_mean", "double",
        std::vector<size_t>{});
      sig2_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 67;
      sig2_mean = context__.vals_r("sig2_mean")[(1 - 1)];
      current_statement__ = 68;
      context__.validate_dims("data initialization", "sig2_sd", "double",
        std::vector<size_t>{});
      sig2_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 68;
      sig2_sd = context__.vals_r("sig2_sd")[(1 - 1)];
      current_statement__ = 69;
      context__.validate_dims("data initialization", "link_choice", "int",
        std::vector<size_t>{});
      link_choice = std::numeric_limits<int>::min();
      current_statement__ = 69;
      link_choice = context__.vals_i("link_choice")[(1 - 1)];
      current_statement__ = 69;
      stan::math::check_greater_or_equal(function__, "link_choice",
        link_choice, 1);
      current_statement__ = 69;
      stan::math::check_less_or_equal(function__, "link_choice", link_choice,
        4);
      current_statement__ = 70;
      context__.validate_dims("data initialization", "model_type", "int",
        std::vector<size_t>{});
      model_type = std::numeric_limits<int>::min();
      current_statement__ = 70;
      model_type = context__.vals_i("model_type")[(1 - 1)];
      current_statement__ = 70;
      stan::math::check_greater_or_equal(function__, "model_type",
        model_type, 1);
      current_statement__ = 70;
      stan::math::check_less_or_equal(function__, "model_type", model_type, 2);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("Coef", "K", K);
      current_statement__ = 72;
      sig2_scale_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 72;
      sig2_scale_1dim__ = (stan::math::logical_eq(model_type, 2) ? 1 : 0);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("sig2_scale",
        "model_type == 2 ? 1 : 0", sig2_scale_1dim__);
      current_statement__ = 73;
      pair_effects_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 73;
      pair_effects_1dim__ = (stan::math::logical_eq(model_type, 2) ? N : 0);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("pair_effects",
        "model_type == 2 ? N : 0", pair_effects_1dim__);
      current_statement__ = 74;
      stan::math::validate_non_negative_index("eta", "N", N);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("loglik", "N", N);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("mu", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = K + 1 + sig2_scale_1dim__ + pair_effects_1dim__;
  }
  inline std::string model_name() const final {
    return "model_betareg";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_betareg_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> Coef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 1;
      Coef = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      std::vector<local_scalar_t__> sig2_scale =
        std::vector<local_scalar_t__>(sig2_scale_1dim__, DUMMY_VAR__);
      current_statement__ = 3;
      sig2_scale = in__.template read_constrain_lb<
                     std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                     sig2_scale_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> pair_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(pair_effects_1dim__,
          DUMMY_VAR__);
      current_statement__ = 4;
      pair_effects = in__.template read<
                       Eigen::Matrix<local_scalar_t__,-1,1>>(pair_effects_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 12;
      if (stan::math::logical_eq(model_type, 2)) {
        current_statement__ = 10;
        stan::model::assign(eta,
          stan::math::add(stan::math::multiply(X, Coef), pair_effects),
          "assigning variable eta");
      } else {
        current_statement__ = 8;
        stan::model::assign(eta, stan::math::multiply(X, Coef),
          "assigning variable eta");
      }
      {
        current_statement__ = 30;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(Coef, coef_mean,
                         coef_sd));
        current_statement__ = 31;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(phi, phi_shape,
                         phi_rate));
        current_statement__ = 35;
        if (stan::math::logical_eq(model_type, 2)) {
          current_statement__ = 32;
          lp_accum__.add(stan::math::lognormal_lpdf<propto__>(
                           stan::model::rvalue(sig2_scale, "sig2_scale",
                             stan::model::index_uni(1)), sig2_mean, sig2_sd));
          current_statement__ = 33;
          lp_accum__.add(stan::math::multi_normal_lpdf<propto__>(
                           pair_effects, stan::math::rep_vector(0, N),
                           stan::math::multiply(
                             stan::model::rvalue(sig2_scale, "sig2_scale",
                               stan::model::index_uni(1)), Cp)));
        }
        current_statement__ = 36;
        stan::math::validate_non_negative_index("mu", "N", N);
        Eigen::Matrix<local_scalar_t__,-1,1> mu =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
        current_statement__ = 51;
        if (stan::math::logical_eq(link_choice, 1)) {
          current_statement__ = 49;
          stan::model::assign(mu, stan::math::inv_logit(eta),
            "assigning variable mu");
        } else {
          current_statement__ = 48;
          if (stan::math::logical_eq(link_choice, 2)) {
            current_statement__ = 46;
            for (int n = 1; n <= N; ++n) {
              current_statement__ = 44;
              stan::model::assign(mu,
                stan::math::normal_cdf(
                  stan::model::rvalue(eta, "eta", stan::model::index_uni(n)),
                  0, 1), "assigning variable mu", stan::model::index_uni(n));
            }
          } else {
            current_statement__ = 43;
            if (stan::math::logical_eq(link_choice, 3)) {
              current_statement__ = 41;
              stan::model::assign(mu,
                stan::math::subtract(1,
                  stan::math::exp(stan::math::minus(stan::math::exp(eta)))),
                "assigning variable mu");
            } else {
              current_statement__ = 40;
              if (stan::math::logical_eq(link_choice, 4)) {
                current_statement__ = 38;
                stan::model::assign(mu,
                  stan::math::exp(
                    stan::math::minus(stan::math::exp(stan::math::minus(eta)))),
                  "assigning variable mu");
              }
            }
          }
        }
        current_statement__ = 52;
        lp_accum__.add(stan::math::beta_lpdf<propto__>(Y,
                         stan::math::multiply(mu, phi),
                         stan::math::multiply(stan::math::subtract(1, mu),
                           phi)));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_betareg_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> Coef =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      Coef = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      double phi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      phi = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      std::vector<double> sig2_scale =
        std::vector<double>(sig2_scale_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      sig2_scale = in__.template read_constrain_lb<
                     std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                     sig2_scale_1dim__);
      Eigen::Matrix<double,-1,1> pair_effects =
        Eigen::Matrix<double,-1,1>::Constant(pair_effects_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      pair_effects = in__.template read<
                       Eigen::Matrix<local_scalar_t__,-1,1>>(pair_effects_1dim__);
      Eigen::Matrix<double,-1,1> eta =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(Coef);
      out__.write(phi);
      out__.write(sig2_scale);
      out__.write(pair_effects);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 12;
      if (stan::math::logical_eq(model_type, 2)) {
        current_statement__ = 10;
        stan::model::assign(eta,
          stan::math::add(stan::math::multiply(X, Coef), pair_effects),
          "assigning variable eta");
      } else {
        current_statement__ = 8;
        stan::model::assign(eta, stan::math::multiply(X, Coef),
          "assigning variable eta");
      }
      if (emit_transformed_parameters__) {
        out__.write(eta);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> loglik =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> mu =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 26;
      if (stan::math::logical_eq(link_choice, 1)) {
        current_statement__ = 24;
        stan::model::assign(mu, stan::math::inv_logit(eta),
          "assigning variable mu");
      } else {
        current_statement__ = 23;
        if (stan::math::logical_eq(link_choice, 2)) {
          current_statement__ = 21;
          for (int n = 1; n <= N; ++n) {
            current_statement__ = 19;
            stan::model::assign(mu,
              stan::math::normal_cdf(
                stan::model::rvalue(eta, "eta", stan::model::index_uni(n)),
                0, 1), "assigning variable mu", stan::model::index_uni(n));
          }
        } else {
          current_statement__ = 18;
          if (stan::math::logical_eq(link_choice, 3)) {
            current_statement__ = 16;
            stan::model::assign(mu,
              stan::math::subtract(1,
                stan::math::exp(stan::math::minus(stan::math::exp(eta)))),
              "assigning variable mu");
          } else {
            current_statement__ = 15;
            if (stan::math::logical_eq(link_choice, 4)) {
              current_statement__ = 13;
              stan::model::assign(mu,
                stan::math::exp(
                  stan::math::minus(stan::math::exp(stan::math::minus(eta)))),
                "assigning variable mu");
            }
          }
        }
      }
      current_statement__ = 29;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 27;
        stan::model::assign(loglik,
          stan::math::beta_lpdf<false>(
            stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
            (stan::model::rvalue(mu, "mu", stan::model::index_uni(n)) * phi),
            ((1 - stan::model::rvalue(mu, "mu", stan::model::index_uni(n))) *
            phi)), "assigning variable loglik", stan::model::index_uni(n));
      }
      out__.write(loglik);
      out__.write(mu);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> Coef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(Coef,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable Coef");
      out__.write(Coef);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, phi);
      std::vector<local_scalar_t__> sig2_scale =
        std::vector<local_scalar_t__>(sig2_scale_1dim__, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(sig2_scale,
        in__.read<std::vector<local_scalar_t__>>(sig2_scale_1dim__),
        "assigning variable sig2_scale");
      out__.write_free_lb(0, sig2_scale);
      Eigen::Matrix<local_scalar_t__,-1,1> pair_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(pair_effects_1dim__,
          DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(pair_effects,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(pair_effects_1dim__),
        "assigning variable pair_effects");
      out__.write(pair_effects);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "Coef", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "phi", "double",
        std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sig2_scale",
        "double",
        std::vector<size_t>{static_cast<size_t>(sig2_scale_1dim__)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "pair_effects",
        "double",
        std::vector<size_t>{static_cast<size_t>(pair_effects_1dim__)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> Coef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> Coef_flat__;
        current_statement__ = 1;
        Coef_flat__ = context__.vals_r("Coef");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(Coef, Coef_flat__[(pos__ - 1)],
            "assigning variable Coef", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(Coef);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = context__.vals_r("phi")[(1 - 1)];
      out__.write_free_lb(0, phi);
      std::vector<local_scalar_t__> sig2_scale =
        std::vector<local_scalar_t__>(sig2_scale_1dim__, DUMMY_VAR__);
      current_statement__ = 3;
      sig2_scale = context__.vals_r("sig2_scale");
      out__.write_free_lb(0, sig2_scale);
      Eigen::Matrix<local_scalar_t__,-1,1> pair_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(pair_effects_1dim__,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> pair_effects_flat__;
        current_statement__ = 4;
        pair_effects_flat__ = context__.vals_r("pair_effects");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= pair_effects_1dim__; ++sym1__) {
          current_statement__ = 4;
          stan::model::assign(pair_effects, pair_effects_flat__[(pos__ - 1)],
            "assigning variable pair_effects", stan::model::index_uni(sym1__));
          current_statement__ = 4;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(pair_effects);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"Coef", "phi", "sig2_scale",
                "pair_effects"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"eta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"loglik", "mu"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(K)},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(sig2_scale_1dim__)},
                std::vector<size_t>{static_cast<size_t>(pair_effects_1dim__)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "Coef" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "phi");
    for (int sym1__ = 1; sym1__ <= sig2_scale_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "sig2_scale" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= pair_effects_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "pair_effects" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "eta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "loglik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "Coef" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "phi");
    for (int sym1__ = 1; sym1__ <= sig2_scale_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "sig2_scale" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= pair_effects_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "pair_effects" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "eta" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "loglik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"Coef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sig2_scale\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(sig2_scale_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"pair_effects\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(pair_effects_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"loglik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"Coef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sig2_scale\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(sig2_scale_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"pair_effects\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(pair_effects_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"loglik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((K + 1) + sig2_scale_1dim__) +
      pair_effects_1dim__);
    const size_t num_transformed = emit_transformed_parameters * (N);
    const size_t num_gen_quantities = emit_generated_quantities * ((N + N));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((K + 1) + sig2_scale_1dim__) +
      pair_effects_1dim__);
    const size_t num_transformed = emit_transformed_parameters * (N);
    const size_t num_gen_quantities = emit_generated_quantities * ((N + N));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_betareg_namespace::model_betareg;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_betareg_namespace::profiles__;
}
#endif
#endif
