% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pglmm-utils.R
\name{pglmm_predicted_values}
\alias{pglmm_predicted_values}
\alias{communityPGLMM.predicted.values}
\title{Predicted values of PGLMM}
\usage{
pglmm_predicted_values(
  x,
  cpp = TRUE,
  gaussian.pred = c("nearest_node", "tip_rm"),
  re.form = NULL,
  type = c("link", "response"),
  ...
)

communityPGLMM.predicted.values(
  x,
  cpp = TRUE,
  gaussian.pred = c("nearest_node", "tip_rm")
)
}
\arguments{
\item{x}{A fitted model with class communityPGLMM.}

\item{cpp}{Whether to use c++ code. Default is TRUE.}

\item{gaussian.pred}{When family is gaussian, which type of prediction to calculate?
Option nearest_node will predict values to the nearest node, which is same as lme4::predict or
fitted. Option tip_rm will remove the point then predict the value of this point with remaining ones.}

\item{re.form}{(formula, \code{NULL}, or \code{NA}) specify which random effects to condition on when predicting.
If \code{NULL}, include all random effects (i.e Xb + Zu);
if \code{NA} or \code{~0}, include no random effects (i.e. Xb).}

\item{type}{character string - either \code{"link"}, the default, or
    \code{"response"} indicating the type of prediction object returned.}

\item{...}{Optional additional parameters. None are used at present.}
}
\value{
A data frame with column Y_hat (predicted values accounting for
both fixed and random terms).
}
\description{
\code{pglmm_predicted_values} calculates the predicted
values of Y; for the generalized linear mixed model (family \%in\%
c("binomial","poisson"), these values are in the transformed space.
}
