% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.piar_index.R
\name{merge.piar_index}
\alias{merge.piar_index}
\alias{merge.chainable_piar_index}
\alias{merge.direct_piar_index}
\title{Merge price indexes}
\usage{
\method{merge}{chainable_piar_index}(x, y, ...)

\method{merge}{direct_piar_index}(x, y, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elementary_index]{elementary_index()}}.}

\item{y}{A price index, or something that can coerced into one. If \code{x}
is a period-over-period index then \code{y} is coerced into a chainable
index; otherwise, \code{y} is coerced into a direct index.}

\item{...}{Not currently used.}
}
\value{
A combined price index that inherits from the same class as \code{x}.
}
\description{
Combine two price indexes with common time periods, merging together the
index values and percent-change contributions for each time period.

This is useful for building up an index when different elementary aggregates
come from different sources of data, or use different index-number formulas.
}
\examples{
index1 <- as_index(matrix(1:6, 2))

index2 <- index1
levels(index2) <- 3:4

merge(index1, index2)

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{as.ts.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{window.piar_index}()}
}
\concept{index methods}
