% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickmax.R
\name{pickmax}
\alias{pickmax}
\title{Split and Coalesce Duplicated Records}
\usage{
pickmax(df, key_col = "id", diff_cutoff = 0.5)
}
\arguments{
\item{df}{A data frame or tibble.}

\item{key_col}{Character. Name of the column to identify duplicates.}

\item{diff_cutoff}{Numeric between 0 and 1. Proportion of comparable fields that must differ
for a duplicated record to be split into its own ID. Differences below this cutoff are treated
as acceptable and those rows will stay merged under the original key. Defaults to 0.5 (50 percent).}
}
\value{
A named list with three data frames:
\describe{
  \item{\code{duplicates_df}}{All rows flagged as duplicates, ordered by completeness.}
  \item{\code{split_df}}{Rows split off because they exceeded \code{diff_cutoff}.}
  \item{\code{coalesced_df}}{The final deduplicated data frame, coalesced prioritising completeness.}
}
}
\description{
Deduplicates datasets by retaining the most complete and informative records. Identifies duplicated entries based on a specified key column, calculates completeness scores for each row, and compares values within groups. When differences between duplicates exceed a user-defined threshold, records are split into unique IDs; otherwise, they are coalesced into a single, most complete entry. Returns a list containing the original duplicates, the split entries, and the final coalesced dataset. Useful for cleaning survey or administrative data where duplicated IDs may reflect minor data entry inconsistencies.
}
\details{
This function:
  1. Computes a completeness percentage for each record.
  2. Flags duplicates and checks if the proportion of differing fields
     relative to the most complete record exceeds `diff_cutoff`.
    - Records exceeding the threshold are split with new IDs.
    - Others are merged using the most complete non‑NA values.
}
\examples{
# Create a small sample with real duplicates
df <- data.frame(
  id    = c(1, 1, 2, 2, 3, 4, 4),
  value = c(10, 10, NA, 20, 5, 3, 3),
  tag   = c("A", "A", NA, "B", "C", "X", NA),
  stringsAsFactors = FALSE
)

# Run pickmax with default diff_cutoff (50\%)
res <- pickmax(df, key_col = "id", diff_cutoff = 0.5)

# Show the duplicates flagged
print(res$duplicates_df)

# Show records that got split per diff_cutoff
print(res$split_df)

# Show final cleaned dataset
print(res$coalesced_df)

}
