% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exr-attributes.R
\name{exr_attrs}
\alias{exr_attrs}
\title{Helper function to create attributes for \code{\link{write_exr}()}}
\usage{
exr_attrs(
  channels = NULL,
  compression = NULL,
  dataWindow = NULL,
  displayWindow = NULL,
  lineOrder = NULL,
  pixelAspectRatio = NULL,
  screenWindowCenter = NULL,
  screenWindowWidth = NULL,
  ...
)
}
\arguments{
\item{channels}{\code{[exr_type$chlist()]} data.frame of channel
information with columns name [string], type ['half', 'float', 'uint'],
pLinear [0, 1], xSampling [0, 1], ySampling [0, 1]}

\item{compression}{\code{[exr_type$compression()]} 'NONE' or 'ZIP'}

\item{dataWindow}{\code{[exr_type$box2i()]} xmin, ymin, xmax, ymax
of data. Default: image size c(0, 0, w-1, h-1)}

\item{displayWindow}{\code{[exr_type$box2i()]} xmin, ymin, xmax, ymax
of display. Default: image size c(0, 0, w-1, h-1)}

\item{lineOrder}{\code{[exr_type$lineOrder()]} Line ordering. One of
'increasing', 'decreasing' or 'random'.  Default: 'increasing'}

\item{pixelAspectRatio}{\code{[exr_type$float()]}. Default: 1.0}

\item{screenWindowCenter}{\code{[exr_type$v2f()]}. Default: c(0.0, 0.0)}

\item{screenWindowWidth}{\code{[exr_type$float()]}. Default: 1.0}

\item{...}{Other named parameters. value must be of class \code{exr_type}
e.g. \code{myLabel = exr_type$string("potpourri")}.}
}
\value{
named list of attributes for writing EXR
}
\description{
The EXR file specification requires particular types to define the 
metadata for the image.  This function helps define these metadata
attributes.
}
\details{
In the majority of cases for basic image output, there is no need to specify
anything with this function.  \code{\link{write_exr}()} will create mandatory 
attributes required for image output.

Note that all values must be an object with class \code{exr_type}.  To 
create these types, use \code{exr_type$<TYPE>(...)}.
}
\examples{
exr_attrs(compression = exr_type$compression("ZIP"), 
          name        = exr_type$string("Render 032"))
}
