% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{eng_pikchr_validate_options}
\alias{eng_pikchr_validate_options}
\title{Validate Knitr Chunk Options for Pikchr Engine}
\usage{
eng_pikchr_validate_options(options)
}
\arguments{
\item{options}{A list of options passed to the Pikchr engine from a Knitr code chunk. These options include directives such as `eval`, `echo`, and `warning`.}
}
\value{
The validated options list, where unsupported numeric values are converted to `TRUE`.
}
\description{
This function validates the chunk options provided to the Pikchr engine in Knitr. 
It checks for unsupported numeric options and converts them to logical `TRUE` values.
A warning is issued if any unsupported numeric options are detected.
}
\details{
The `eng_pikchr_validate_options` function looks for specific options (e.g., `eval`, `echo`, `warning`) that should not be numeric. If any of these options are numeric, they are converted to logical `TRUE` and a warning is issued to the user.
}
\keyword{internal}
