% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plainView.R
\name{plainViewOutput}
\alias{plainViewOutput}
\alias{renderPlainView}
\title{Widget output/render function for use in Shiny}
\usage{
plainViewOutput(outputId, width = "100\%", height = "400px")

renderPlainView(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from}

\item{width, height}{the width and height of the map
(see \code{\link[htmlwidgets]{shinyWidgetOutput}})}

\item{expr}{An expression that generates an HTML widget}

\item{env}{The environment in which to evaluate expr}

\item{quoted}{Is expr a quoted expression (with quote())?
This is useful if you want to save an expression in a variable}
}
\description{
Widget output/render function for use in Shiny
}
\examples{
if (interactive()) {
  library(shiny)

  plt = plainView(poppendorf[[4]])

  ui = fluidPage(
    plainViewOutput("plot")
  )

  server = function(input, output, session) {
    output$plot <- renderPlainView(plt)
  }

  shinyApp(ui, server)

}

}
