% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{errorBars}
\alias{errorBars}
\title{Add error bars to a plot.}
\usage{
errorBars(
  x,
  mean,
  ci,
  ci.l = NULL,
  minmax = NULL,
  horiz = FALSE,
  border = FALSE,
  ...
)
}
\arguments{
\item{x}{Vector with x-values (or y-values in case \code{horiz=TRUE}).}

\item{mean}{Vector with means.}

\item{ci}{Vector with errors or confidence bands, e.g. SE values. If 
\code{ci.l} is not defined, the errors are assumed to be symmetric. If 
\code{ci.l} is defined, than \code{ci} is assumed to be the upper 
confidence band. Note that the \code{ci} will be added (or substracted) 
from the mean.}

\item{ci.l}{Optional: vector with error to calculate lower confidence band.}

\item{minmax}{Optional argument, vector with two values indicating the 
minimum and maximum value for the error bars. If NULL (default) the error 
bars are not corrected.}

\item{horiz}{Logical: whether or not to plot horizontal error bars. 
Defaults to FALSE (plotting vertical error bars).}

\item{border}{Logical: whether or not to add a border around the error 
bars. Defaults to FALSE (no border added). 
Color and width of the borders can be adjusted using \code{border.col} and 
\code{border.width}. (Basically all parameters that work for errorBars, 
with \code{border.} added before.) See examples.}

\item{...}{Optional graphical parameters (see \code{\link[graphics]{par}}).}
}
\description{
Add vertical error bars.
}
\examples{

# example InsectSprays from R datasets

InsectSprays$type <- ifelse( InsectSprays$spray \%in\% c('A', 'B', 'F'), 1,2)
avg <- with(InsectSprays, tapply(count, list(spray), mean))
sds <- with(InsectSprays, tapply(count, list(spray), sd))


# barplot:
b <- barplot(avg, beside=TRUE, main='Insect Sprays', ylim=c(0,20))
errorBars(b, avg, sds, xpd=TRUE, length=.05)

# constrain error bars to max and min of plot:
b <- barplot(avg, beside=TRUE, main='Insect Sprays', ylim=c(0,20))
errorBars(b, avg, sds, minmax=c(0,20), xpd=TRUE, length=.05)                

# add borders:
b <- barplot(avg, beside=TRUE, main='Insect Sprays', ylim=c(0,20),
     col=1, border=NA)
errorBars(b, avg, sds, minmax=c(0,20), xpd=TRUE, length=.05, border=TRUE) 

# change layout:
b <- barplot(avg, beside=TRUE, main='Insect Sprays', ylim=c(0,20),
     col=1, border=NA)
errorBars(b, avg, sds, minmax=c(0,20), xpd=TRUE, border=TRUE, 
     length=.05, col='blue', # settings for error bars 
     border.length=.1, border.col='yellow', border.lwd=5) # settings border

# line plot with asymmetric fake errors:
emptyPlot(toupper(letters[1:6]), 20, main='Averages', xlab='Spray')
ci.low <- abs(rnorm(6, mean=2))
ci.high <-  abs(rnorm(6, mean=4))

errorBars(1:6, avg, ci.high, ci.l= ci.low, length=.05, lwd=2)
points(1:6, avg, pch=21, type='o', lty=3, lwd=2,
    bg='white', xpd=TRUE)
# also horizontal bars possible:
errorBars(10, 1, 1.2, horiz=TRUE, col='red')

}
\seealso{
Other Functions for plotting: 
\code{\link{addInterval}()},
\code{\link{add_bars}()},
\code{\link{add_n_points}()},
\code{\link{alpha}()},
\code{\link{alphaPalette}()},
\code{\link{check_normaldist}()},
\code{\link{color_contour}()},
\code{\link{dotplot_error}()},
\code{\link{drawDevArrows}()},
\code{\link{emptyPlot}()},
\code{\link{fill_area}()},
\code{\link{getCoords}()},
\code{\link{getFigCoords}()},
\code{\link{getProps}()},
\code{\link{gradientLegend}()},
\code{\link{legend_margin}()},
\code{\link{marginDensityPlot}()},
\code{\link{plot_error}()},
\code{\link{plot_image}()},
\code{\link{plotsurface}()},
\code{\link{sortBoxplot}()}
}
\author{
Jacolien van Rij
}
\concept{Functions for plotting}
