% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfolds2CVinfos_beta.R
\name{kfolds2CVinfos_beta}
\alias{kfolds2CVinfos_beta}
\title{Extracts and computes information criteria and fits statistics for kfold
cross validated partial least squares beta regression models}
\usage{
kfolds2CVinfos_beta(pls_kfolds, MClassed = FALSE)
}
\arguments{
\item{pls_kfolds}{an object computed using \code{\link{PLS_beta_kfoldcv}}}

\item{MClassed}{should number of miss classed be computed}
}
\value{
\item{list}{table of fit statistics for first group partition}
\item{list()}{\dots{}} \item{list}{table of fit statistics for last group
partition}
}
\description{
This function extracts and computes information criteria and fits statistics
for kfold cross validated partial least squares beta regression models for
both formula or classic specifications of the model.
}
\details{
The Mclassed option should only set to \code{TRUE} if the response is
binary.
}
\examples{

\dontrun{
data("GasolineYield",package="betareg")
bbb <- PLS_beta_kfoldcv_formula(yield~.,data=GasolineYield,nt=3,modele="pls-beta")
kfolds2CVinfos_beta(bbb)
}

}
\references{
Frédéric Bertrand, Nicolas Meyer,
Michèle Beau-Faller, Karim El Bayed, Izzie-Jacques Namer,
Myriam Maumy-Bertrand (2013). Régression Bêta
PLS. \emph{Journal de la Société Française de Statistique},
\bold{154}(3):143-159.
\url{https://ojs-test.apps.ocp.math.cnrs.fr/index.php/J-SFdS/article/view/215}
}
\seealso{
\code{\link[plsRglm]{kfolds2coeff}},
\code{\link[plsRglm]{kfolds2Pressind}}, \code{\link[plsRglm]{kfolds2Press}},
\code{\link[plsRglm]{kfolds2Mclassedind}} and
\code{\link[plsRglm]{kfolds2Mclassed}} to extract and transforms results
from kfold cross validation.
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
\keyword{regression}
