% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvtable.R
\name{cvtable}
\alias{cvtable}
\alias{cvtable.plsR}
\alias{cvtable.plsRglm}
\title{Table method for summary of cross validated PLSR and PLSGLR models}
\usage{
cvtable(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{an object of the class \code{"summary.cv.plsRmodel"}}

\item{verbose}{should results be displayed ?}

\item{\dots}{further arguments to be passed to or from methods.}
}
\value{
\code{list}List of Information Criteria computed for each fold.
}
\description{
The function \code{cvtable} is wrapper of \code{cvtable.plsR} and
\code{cvtable.plsRglm} that provides a table summary for the classes
\code{"summary.cv.plsRmodel"} and \code{"summary.cv.plsRglmmodel"}
}
\examples{

data(Cornell)
cv.modpls <- cv.plsR(Y~.,data=Cornell,nt=6,K=6,NK=5)
res.cv.modpls <- cvtable(summary(cv.modpls))
plot(res.cv.modpls) #defaults to type="CVQ2"
rm(list=c("cv.modpls","res.cv.modpls"))

\donttest{
data(Cornell)
cv.modpls <- cv.plsR(Y~.,data=Cornell,nt=6,K=6,NK=25,verbose=FALSE)
res.cv.modpls <- cvtable(summary(cv.modpls))
plot(res.cv.modpls) #defaults to type="CVQ2"
rm(list=c("cv.modpls","res.cv.modpls"))
	
data(Cornell)
cv.modpls <- cv.plsR(Y~.,data=Cornell,nt=6,K=6,NK=100,verbose=FALSE)
res.cv.modpls <- cvtable(summary(cv.modpls))
plot(res.cv.modpls) #defaults to type="CVQ2"
rm(list=c("cv.modpls","res.cv.modpls"))

data(Cornell)
cv.modplsglm <- cv.plsRglm(Y~.,data=Cornell,nt=6,K=6,
modele="pls-glm-gaussian",NK=100,verbose=FALSE)
res.cv.modplsglm <- cvtable(summary(cv.modplsglm))
plot(res.cv.modplsglm) #defaults to type="CVQ2Chi2"
rm(list=c("res.cv.modplsglm"))
}

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparing the linear and the
logistic PLS regression with qualitative predictors: application to
allelotyping data. \emph{Journal de la Societe Francaise de Statistique},
151(2), pages 1-18.
\url{https://www.numdam.org/item/JSFS_2010__151_2_1_0/}
}
\seealso{
\code{\link{summary}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{methods}
\keyword{print}
