% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_auth.R
\name{api_auth}
\alias{api_auth}
\title{Add auth to an endpoint}
\usage{
api_auth(api, method, path, auth_flow, auth_scope = NULL, add_doc = TRUE)
}
\arguments{
\item{api}{A plumber2 api object to add authentication to}

\item{method}{The HTTP method to add authentication to}

\item{path}{A string giving the path to be authenticated}

\item{auth_flow}{A logical expression giving the authentication flow the
client must pass to get access to the resource.}

\item{auth_scope}{The scope requirements of the resource}

\item{add_doc}{Should OpenAPI documentation be added for the
authentication}
}
\value{
This functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
This function adds auth to a specific method + path. It does so by
defining an auth flow which the request must pass in order to proceed, as
well as an optional vector of scopes required. The flow is given as a logical
expression of \link[=api_auth_guard]{guards} it must satisfy. If you
have registered two guards, \code{auth1} and \code{auth2}, then a flow could be
\code{auth1 && auth2} to require that both guards must be passed to gain
access. Alternatively you could use \code{auth1 || auth2} to require that just one
of them are passed. Flows can be arbitrarily complex with nesting etc, but
the OpenAPI spec has limits to what it can describe so if you want to have an
OpenAPI compliant api you must limit yourself to at most two levels of
nesting with the outer level being \code{||} (ie.
\code{(auth1 && auth2) || (auth3 && auth4)} is ok, but
\code{(auth1 || auth2) && (auth3 || auth4)} is not due to the outer level being
\code{&&}, and \code{(auth1 && auth2) || (auth3 && (auth4 || auth5))} is not allowed
because it has 3 nesting levels). This is only a limitation of OpenAPI and
plumber2 itself can handle all of the above. If scope is given the scope of
the user after successful authentication must contain \emph{all} of the provided
scopes. While this function allows you to add authentication to a path
directly, it is often more convenient to add it along with the resource or
functionality you want to protect. To that end, many functions such as
\code{\link[=api_get]{api_get()}} and \code{\link[=api_report]{api_report()}} also takes \code{auth_flow} and \code{auth_scope} as
input and if given will add auth to the relevant endpoint.
}
\examples{
# We are not adding the guards here - only the auth flow
# We assume the guards `oauth`, `basic`, and `key` will be added
# later
api() |>
  api_datastore(storr::driver_environment()) |>
  api_auth(
    method = "get",
    path = "/user/<username>",
    auth_flow = oauth || (basic && key)
  )

}
