% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowess_cal.R
\name{lowess_cal}
\alias{lowess_cal}
\title{calibration curve via \code{lowess}}
\usage{
lowess_cal(p, y, x, xp, save_data = TRUE)
}
\arguments{
\item{p}{predicted probabilities}

\item{y}{binary outcome}

\item{x}{predictor (could be transformation of \code{p})}

\item{xp}{values for plotting (same scale as \code{x})}

\item{save_data}{whether to save y, p, x, xp in the returned object}
}
\value{
list of class \code{lowess_cal}
}
\description{
uses \code{lowess} with \code{iter} = 0; as done in the \code{rms} package
}
\examples{
library(pmcalibration)
# simulate some data
n <- 500
dat <- sim_dat(N = n, a1 = .5, a3 = .2)

# predictions
p <- with(dat, invlogit(.5 + x1 + x2 + x1*x2*.1))

lowess_cal(y = dat$y, p = p, x = p, xp = NULL)
}
\keyword{internal}
