% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_plot.R
\name{mape_stability}
\alias{mape_stability}
\title{Mean absolute predictor error (MAPE) stability plot}
\usage{
mape_stability(x, xlim, ylim, xlab, ylab, pch, cex, col, subset, plot = TRUE)
}
\arguments{
\item{x}{an object produced by \code{\link{validate}} with method = "boot_*" (or \code{\link{boot_optimism}} with method="boot")}

\item{xlim}{x limits (default = range of estimated risks)}

\item{ylim}{y limits (default = c(0, maximum mape))}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{pch}{plotting character (default = 16)}

\item{cex}{controls point size (default = 1)}

\item{col}{color of points (default = grDevices::grey(.5, .5))}

\item{subset}{vector of observations to include (row indices). This can be used to select a random subset of observations.}

\item{plot}{if FALSE just returns MAPE values (see value)}
}
\value{
plots calibration (in)stability.
Invisibly returns a list containing individual and average MAPE.
}
\description{
A MAPE (in)stability plot shows mean absolute predictor error (average absolute difference between original
estimated risk and risk from B bootstrap models) as a function of apparent
estimated risk (prediction from original/development model). See Riley and Collins (2023).
}
\examples{
set.seed(456)
# simulate data with two predictors that interact
dat <- pmcalibration::sim_dat(N = 2000, a1 = -2, a3 = -.3)
mean(dat$y)
dat$LP <- NULL # remove linear predictor

# fit a (misspecified) logistic regression model
m1 <- glm(y ~ ., data=dat, family="binomial")

# internal validation of m1 via bootstrap optimism with 10 resamples
# B = 10 for example but should be >= 200 in practice
m1_iv <- validate(m1, method="boot_optimism", B=10)

mape_stability(m1_iv)

}
\references{
Riley, R. D., & Collins, G. S. (2023). Stability of clinical prediction models developed using statistical or machine learning methods. Biometrical Journal, 65(8), 2200302. doi:10.1002/bimj.202200302
}
