% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_converters.R
\name{nn_converter_mlx}
\alias{nn_converter_mlx}
\title{NN converter for Monolix}
\usage{
nn_converter_mlx(
  mlx_path,
  pop_only = FALSE,
  theta_scale = 0.1,
  eta_scale = 0.1,
  pre_fixef = NULL,
  gen_mlx_file = FALSE,
  mlx_name = NULL,
  data_file = NULL,
  header_types = NULL,
  obs_types = NULL,
  mapping = NULL,
  seed = 1908
)
}
\arguments{
\item{mlx_path}{(string) (Path/)Name of the unconverted Monolix model file}

\item{pop_only}{(boolean) If the generated Monolix \emph{.mlxtran} file should be a fit without (TRUE) or with (FALSE)
inter-individual variability on NN parameters}

\item{theta_scale}{(numeric) Scale in which typical NN parameter values are initialized, default is 0.1, i.e., weights are 
initialized between -0.3 and 0.3}

\item{eta_scale}{(numeric) Initial standard deviation of random effects on NN parameters, default is 0.1}

\item{pre_fixef}{(named vector) Specific initial values for typical parameters, can be optained with the 
\emph{pre_fixef_extractor_mlx} function from a previous Monolix run}

\item{gen_mlx_file}{(boolean) If a Monolix \emph{.mlxtran} file with already initialized parameters and estimation
settigs should be generated}

\item{mlx_name}{(string) Optional, name of the generated Monolix file (\emph{mlx_name}.mlxtran). If no name is given and 
\emph{gen_mlx_file}=TRUE, name of the Monolix file will be \emph{unconverted_model_name}_\strong{mlx_file}_\strong{pop/ind}.mlxtran,
with pop or ind depending whether \emph{pop}=TRUE or \emph{pop}=FALSE,respectively.}

\item{data_file}{(string) Required if \emph{gen_mlx_file}=TRUE, (Path/)Name of the data file to be used}

\item{header_types}{(vector) Required if \emph{gen_mlx_file}=TRUE, Vector of strings describing column types of data. Possible header types: 
ignore, id, time, observation, amount, contcov, catcov, occ, evid, mdv, obsid, cens, limit, regressor, nominaltime, admid, rate, tinf, ss, ii, addl, date}

\item{obs_types}{(list) List of types of observations, e.g., \dQuote{continuous}; only required if non-continuous observations}

\item{mapping}{(list) List of mapping between model outputs and observation IDs}

\item{seed}{(numeric) Seed for random parameter initialization.}
}
\value{
Saving a converted Monolix model file under \emph{mlx_path}_converted.txt and optionally a Monolix file (\emph{mlx_name}.mlxtran)
if \emph{gen_mlx_file}=TRUE
}
\description{
This function converts a Monolix model file that includes pseudo-functions for NNs as described in \strong{Details}
into a model that can be used in Monolix. An example Monolix model can be opened with the function \emph{open_mlx_example()}.
In addition, it allows to generate a Monolix \emph{.mlxtran} file with automatically initialized parameters and estimation settings.
}
\details{
An example of model file could look like following \cr
\preformatted{DESCRIPTION:} 
\preformatted{A Monolix model for conversion} 
\preformatted{[LONGITUDINAL]} 
\preformatted{input = {V=2}} 
\preformatted{PK:} 
\preformatted{depot(target=C)} 
\preformatted{EQUATION:} 
\preformatted{ddt_C = NN1(state=C,min_init=1,max_init=300) +}
\preformatted{                amtDose * NN2(state=t,min_init=0.5,max_init=50,time_nn=TRUE)} 
\preformatted{Cc = C/V} 
\preformatted{OUTPUT:} 
\preformatted{output = Cc} 
\itemize{
  \item Note that the parameters in the \emph{input} need to have an initial value
  \item NN functions need to be of form NN\strong{X}(...) where X is the name of the NN so references between
  the same NN, e.g., as output of absorption compartment and input to central compartment, can be made. Arguments to NNX are
  \itemize{
    \item \emph{state=} defines the state to be used in the NN. For time, use \emph{t}.
    \item \emph{min_init=} defines the minimal activation point for the NN, i.e., minimal expected state
    \item \emph{max_init=} defines the maximal activation point for the NN, i.e., maximal expected state
    \item \emph{n_hidden=} (optional) defines the number of neurons in the hidden layer, default is 5
    \item \emph{act=} (optional) defines activation function in the hidden layer, ReLU and Softplus implemented, default is ReLU
    \item \emph{time_nn=} (optional) defines whether the NN should be assumed to be a time-dependent NN
    and consequently all weights from input to hidden layer should be strictly negative.
  }
}

Note: Converted Monolix model file will be saved under \emph{unconverted_file}_converted.txt
}
\examples{
\dontrun{
nn_converter_mlx("mlx_model2.txt",
                 pop_only=TRUE,gen_mlx_file=TRUE,
                 data_file="TMDD_dataset.csv",
                 header_types=c("id","time","amount","observation"))

est_parms <- pre_fixef_extractor_mlx("mlx_model2_time_nn_mlx_file_pop.mlxtran")

nn_converter_mlx("mlx_model2.txt",
                 pop_only=FALSE,gen_mlx_file=TRUE,
                 data_file="TMDD_dataset.csv",
                 header_types=c("id","time","amount","observation"),
                 pre_fixef=est_parms)
}
}
\author{
Dominic Bräm
}
