% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxode2user.R
\name{NNbsv}
\alias{NNbsv}
\title{Change a population Neural Network model to a model with between subject variability}
\usage{
NNbsv(ui, val = 0.1, str = "\%s <- l\%s*exp(eta.\%s)", warn = FALSE)
}
\arguments{
\item{ui}{-- nlmixr2 fit or rxode2 model function to modify and add
between subject variabilities to the neural network.}

\item{val}{-- initial value for the added etas}

\item{str}{-- String used to construct the eta expressions.  The
default is "%s <- l%s*exp(eta.%s)". This translates the variable
to the `eta` variable.  If desired you can try different forms
for the between subject variables.}

\item{warn}{-- boolean; Should you warn or error if the element is
not a nlmixr2 fit}
}
\value{
modified model with between subject variabilities added for
  neural-network components.
}
\description{
This only changes the Neural Network model to add between subject
variability.  It assumes the following parameter structure
}
\examples{
\dontrun{
f_ode_pop <- function(){
  ini({
    lV <- 1
    prop.err <- 0.1
  })
  model({
    V <- lV
    d/dt(centr)  =  NN(1, state=centr,min_init=0,max_init=300)
    cp = centr / V
    cp ~ prop(prop.err)
  })
}

f_ode_pop() \%>\% NNbsv(.2, warn=TRUE)
}
}
\author{
Matthew L. Fidler
}
