% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson.R
\name{poisson2d}
\alias{poisson2d}
\title{Generate Poisson disk samples in 2D}
\usage{
poisson2d(w = 10, h = 10, r = 2, k = 30L, verbosity = 0L)
}
\arguments{
\item{w, h}{width and height of region}

\item{r}{minimum distance between points}

\item{k}{number of sample points to generate at each iteration. default 30}

\item{verbosity}{Verbosity level. default: 0}
}
\value{
data.frame with x and y coordinates. Points are returned in 
    the order in which they were generated.
}
\description{
Generate Poisson disk samples in 2D
}
\examples{
pts <- poisson2d(w = 40, h = 40, r = 1)
plot(pts, asp = 1, ann = FALSE, axes = FALSE, pch = 19)
}
