% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic.R
\name{gather_related_terms}
\alias{gather_related_terms}
\title{Gather terms related to subjects}
\usage{
gather_related_terms(.data, dictionary)
}
\arguments{
\item{.data}{A data frame, priorities data frame coded using
`select_priorities()`, or text vector.
For data frames, function will search for "text" variable.
For priorities data frame function will search for "priorities" variable.}

\item{dictionary}{The dictionary of 20 major political topics from the
Comparative Agendas Project (Jones et al., 2023) is used by default.
Users can also declare a custom dictionary as a vector or a list.
If users declare a vector, each element is treated as a independent topic.
If users declare a list of subjects and related terms, function understands
names as topic and words as terms.}
}
\value{
A list of related terms to each of the topics declared in dictionary.
}
\description{
Gather terms related to subjects
}
\details{
This function relies on keyword assisted topic models implemented
in the `\{keyATM\}` package to find related words based on the topics
provided and texts in which they appear.
}
\examples{
#gather_related_terms(US_News_Conferences_1960_1980[1:5, 3], dictionary = "CAP")
#gather_related_terms(US_News_Conferences_1960_1980[1:5, 3],
#                     dictionary = c("military", "development"))
#gather_related_terms(US_News_Conferences_1960_1980[1:5, 3],
#                     dictionary = list("military" = c("military", "gun", "war"),
#                                       "development" = c("development", "interest rate", "banks")))
}
\references{
Eshima S, Imai K, and Sasaki T. 2024.
“Keyword-Assisted Topic Models.”
_American Journal of Political Science_, 68(2): 730-750.
\doi{10.1111/ajps.12779}
}
