% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/href.R
\name{href-function}
\alias{href-function}
\alias{href}
\title{Add hypertext reference to html document.}
\usage{
href(x, href, fmt, verbose = TRUE)
}
\arguments{
\item{x}{Object of class 'html'.}

\item{href}{A named \code{list} with hypertext references that will be inserted as
attribute href of a elements. The names of the list are either colors of
highlighted text that has been generated previously, or corpus positions.}

\item{fmt}{A format string with an xpath expression used to look up the node
where the tooltip is inserted. If missing, a heuristic evaluating the names
of the \code{tooltips} list decides whether tooltips are inserted based on
highlighting colors or corpus positions.}

\item{verbose}{A \code{logical} value, whether to show messages.}
}
\description{
Add hypertext reference to html document.
}
\examples{
use(pkg = "RcppCWB", corpus = "REUTERS")

a <- corpus("REUTERS") \%>\%
  subset(places = "argentina") \%>\%
  html() \%>\%
  highlight(lightgreen = 3997) \%>\%
  href(href = list("3997" = "https://en.wikipedia.org/wiki/Argentina"))
  
if (interactive()) show(a)
}
