% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uSEM.R
\name{model_summary}
\alias{model_summary}
\title{Provide model summary.}
\usage{
model_summary(model.fit, var.number, lag.order)
}
\arguments{
\item{model.fit}{model fit object generated by lavaan}

\item{var.number}{number of variables in the time-series}

\item{lag.order}{lag order of model}
}
\value{
beta matrix estimates

matrix of standard error of beta

matrix of psi estimates

fit statistics CFI

fit statistics TLI

fit statistics RMSEA

fit statistics SRMR
}
\description{
Provide model summary.
}
\details{
Model fit criteria: 3 out of 4 rule,
meaning 3 out of 4 critea should be satisfied,
including CFI and TLI should be greater than 0.95,
RMSEA and SRMR should be less than 0.08.
}
\examples{
\dontshow{
mdl <- model_summary(model.fit = usemmodelfit,
                     var.number = 3,
                     lag.order = 1)
mdl$beta
mdl$beta.se
mdl$psi
mdl$cfi
mdl$tli
mdl$rmsea
mdl$srmr
}
\donttest{
mdl <- model_summary(model.fit = usemmodelfit,
                     var.number = 3,
                     lag.order = 1)
mdl$beta
mdl$beta.se
mdl$psi
mdl$cfi
mdl$tli
mdl$rmsea
mdl$srmr
}

}
