% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{Pfreqs}
\alias{Pfreqs}
\title{Compute allele frequencies from pooled sequencing data}
\usage{
Pfreqs(reference, alternative, coverage, min.minor, ifreqs)
}
\arguments{
\item{reference}{a matrix with the number of reference allele reads. Each row
should be a different population and each column a different site.}

\item{alternative}{a matrix with the number of alternative allele reads. Each
row should be a different population and each column a different site.}

\item{coverage}{a matrix with the total coverage. Each row should be a
different population and each column a different site.}

\item{min.minor}{is an integer representing the minimum allowed number of
minor-allele reads. Sites that, across all populations, have less
minor-allele reads than this threshold will be removed from the data.}

\item{ifreqs}{a vector of allele frequencies computed directly from the
genotypes where each entry corresponds to a different site.}
}
\value{
a list with two entries. The \code{ifreqs} entry contains the allele
frequencies computed directly from genotypes and \code{pfreqs} the allele
frequencies computed from pooled sequencing data.
}
\description{
Computes the frequency of the alternative allele in Pool-seq data and removes
any site with too few minor-allele reads from both the pool frequencies and
the frequencies computed directly from genotypes.
}
\details{
The frequency at a given SNP is calculated according to: \code{pi = c/r}, where c
= number of alternative allele reads and r = total number of observed reads.
Additionally, if a site has less minor-allele reads than \code{min.minor}
across all populations, that site is removed from the data.
}
\examples{
set.seed(10)
# create a vector of allele frequencies
freqs <- runif(20)
set.seed(10)
# create a matrix with the number of reads with the alternative allele
alternative <- matrix(sample(x = c(0,5,10), size = 20, replace = TRUE), nrow = 1)
# create a matrix with the depth of coverage
coverage <- matrix(sample(100:150, size = 20), nrow = 1)
# the number of reads with the reference allele is obtained by subtracting
# the number of alternative allele reads from the depth of coverage
reference <- coverage - alternative
# compute allele frequencies from pooled sequencing data
Pfreqs(reference = reference, alternative = alternative, coverage = coverage,
min.minor = 2, ifreqs = freqs)

}
