% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_snpFstAov}
\alias{compute_snpFstAov}
\alias{.compute_snpFstAov}
\title{compute_snpFstAov}
\usage{
.compute_snpFstAov(refcount, totcount, hapsize, verbose)
}
\arguments{
\item{refcount}{Matrix of nsnpxnpop with counts (genotype or reads) for the reference allele}

\item{totcount}{Matrix of nsnpxnpop with total counts or read coverages}

\item{hapsize}{Vector of length npop giving the haploid size of each pool (if one element <=0, counts are interpreted as count data)}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return a nsnpsx3 matrix with SNP-specific MSG, MSP and nc
}
\description{
Compute SNP-specific MSG, MSP and nc used to derived the Anova estimator of Fst for allele count or read count data (Pool-Seq)
}
\details{
Compute SNP-specific Q1 and Q2 based on Anova estimator of Fst for allele count or read count data (Pool-Seq).
For allele count data, the implemented estimator corresponds to that described in Weir, 1996 (eq. 5.2)  
For read (Pool-Seq) data, the implemented estimator corresponds to that described in Hivert et al., 2016
}
\examples{
#
}
