% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregating.R
\name{as.aggre}
\alias{as.aggre}
\alias{as.aggre.data.frame}
\alias{as.aggre.data.table}
\alias{as.aggre.default}
\title{Coercion to Class \code{aggre}}
\usage{
as.aggre(x, values = NULL, by = NULL, breaks = NULL, ...)

\method{as.aggre}{data.frame}(x, values = NULL, by = NULL, breaks = NULL, ...)

\method{as.aggre}{data.table}(x, values = NULL, by = NULL, breaks = NULL, ...)

\method{as.aggre}{default}(x, ...)
}
\arguments{
\item{x}{a \code{data.frame} or \code{data.table}}

\item{values}{a character string vector; the names of value variables}

\item{by}{a character string vector; the names of variables by which
\code{values} have been tabulated}

\item{breaks}{a list of breaks, where each element is a breaks vector
as usually passed to e.g. \verb{[splitLexisDT]}. The list must be
fully named, with the names corresponding to time scales at the aggregate
level in your data. Every unique value in a time scale variable in data must
also exist in the corresponding vector in the breaks list.}

\item{...}{arguments passed to or from methods}
}
\value{
Returns a copy of \code{x} with attributes set to those of an object of class
\code{"aggre"}.
}
\description{
Coerces an R object to an \code{aggre} object, identifying
the object as one containing aggregated counts, person-years and other
information.
}
\section{Methods (by class)}{
\itemize{
\item \code{as.aggre(data.frame)}: Coerces a \code{data.frame} to an \code{aggre} object

\item \code{as.aggre(data.table)}: Coerces a \code{data.table} to an \code{aggre} object

\item \code{as.aggre(default)}: Default method for \code{as.aggre} (stops computations
if no class-specific method found)

}}
\examples{
library("data.table")
df <- data.frame(sex = rep(c("male", "female"), each = 5),
                 obs = rpois(10, rep(7,5, each=5)),
                 pyrs = rpois(10, lambda = 10000))
dt <- as.data.table(df)

df <- as.aggre(df, values = c("pyrs", "obs"), by = "sex")
dt <- as.aggre(dt, values = c("pyrs", "obs"), by = "sex")

class(df)
class(dt)

BL <- list(fot = 0:5)
df <- data.frame(df)
df <- as.aggre(df, values = c("pyrs", "obs"), by = "sex", breaks = BL)

}
\seealso{
Other aggregation functions: 
\code{\link{aggre}()},
\code{\link{lexpand}()},
\code{\link{setaggre}()},
\code{\link{summary.aggre}()}
}
\author{
Joonas Miettinen
}
\concept{aggregation functions}
