% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection-class.R
\name{projection}
\alias{is.pop_projection}
\alias{plot.pop_projection}
\alias{projection}
\title{Deterministic projection}
\usage{
projection(dynamic, population, timesteps = 1)

is.pop_projection(x)

\method{plot}{pop_projection}(x, states = NULL, patches = 1, ...)
}
\arguments{
\item{dynamic}{a population dynamic model of class \code{\link{dynamic}}}

\item{population}{a dataframe or named vector of positive integers, giving
the number of individuals in each state of \code{dynamic}. If a dataframe,
it should have only one row (as in the examples below), or as many rows as
patches in the metapopulation if a multi-patch landscape has been defined
for \code{dynamic} (using \code{\link{landscape}}). If a multi-patch
landscape has been defined for \code{dynamic}, but \code{population} has
only one row or is a vector, this population will be duplicated for all
patches in the landscape.}

\item{timesteps}{a positive integer giving the number of time steps
(iterations) over which to simulate the model}

\item{x}{a \code{pop_projection} object, or an object to be tested as one}

\item{states}{character vector naming the states in the \code{dynamic} object
used to run the projection that should be plotted. By default all of them
are plotted.}

\item{patches}{vector of positive integers identifying the patches for which
to plot the projections. By default only projections for the first patch
are plotted.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
an object of class \code{pop_projection}
}
\description{
Project a population dynamic model in discrete time, recording
  the number of individuals in each state at each time point.
}
\examples{
# set up a three-stage model
stasis_egg <- tr(egg ~ egg, p(0.6))
stasis_larva <- tr(larva ~ larva, p(0.4))
stasis_adult <- tr(adult ~ adult, p(0.9))
hatching <- tr(larva ~ egg, p(0.35))
fecundity <- tr(egg ~ adult, r(20))
pupation <- tr(adult ~ larva, p(0.2))

pd <- dynamic(stasis_egg,
              stasis_larva,
              stasis_adult,
              hatching,
              pupation,
              fecundity)

population <- data.frame(egg = 1200, larva = 250, adult = 50)

# simulate for 50 timesteps, 30 times
proj <- projection(dynamic = pd,
                   population = population,
                   timesteps = 50)

is.pop_projection(proj)

par(mfrow = c(3, 1))
plot(proj)
}

