% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsExtensionOf.R
\name{IsExtensionOf}
\alias{IsExtensionOf}
\title{Checking poset extensions.}
\usage{
IsExtensionOf(poset1, poset2)
}
\arguments{
\item{poset1}{An object of S4 class 'POSet'.
Argument \code{poset1} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{poset2}{An object of S4 class 'POSet'.
Argument \code{poset2} must be created by using any function contained in the package aimed at building object of S4cl ass \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
A boolean value.
}
\description{
Checks whether poset1 is an extension of poset2.
}
\examples{
elems <- c("a", "b", "c", "d")

dom1 <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

dom2 <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d",
  "a", "c"
), ncol = 2, byrow = TRUE)

pos1 <- POSet(elements = elems, dom = dom1)
pos2 <- POSet(elements = elems, dom = dom2)

chk <- IsExtensionOf(pos1, pos2)

}
